/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.WBSElementTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementText WBSElementText}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class WBSElementTextByKeyFluentHelper
    extends
    FluentHelperByKey<WBSElementTextByKeyFluentHelper, WBSElementText, WBSElementTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementText
     * WBSElementText} entity with the provided key field values. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code WBSElementText}
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code WBSElementText}
     * @param project
     *            Project Definition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public WBSElementTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String language,
        final String wBSElement,
        final String project )
    {
        super(servicePath, entityCollection);
        this.key.put("Language", language);
        this.key.put("WBSElement", wBSElement);
        this.key.put("Project", project);
    }

    @Override
    @Nonnull
    protected Class<WBSElementText> getEntityClass()
    {
        return WBSElementText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
