/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link MasterDataForGroupReportingServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService
 * MasterDataForGroupReportingService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultMasterDataForGroupReportingServiceBatch
    extends
    BatchFluentHelperBasic<MasterDataForGroupReportingServiceBatch, MasterDataForGroupReportingServiceBatchChangeSet>
    implements
    MasterDataForGroupReportingServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultMasterDataForGroupReportingServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMasterDataForGroupReportingServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultMasterDataForGroupReportingServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMasterDataForGroupReportingServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultMasterDataForGroupReportingServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MasterDataForGroupReportingServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultMasterDataForGroupReportingServiceBatchChangeSet(this, service);
    }

}
