/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link MasterDataForGroupReportingServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService
 * MasterDataForGroupReportingService}.
 *
 */
public class DefaultMasterDataForGroupReportingServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<MasterDataForGroupReportingServiceBatch, MasterDataForGroupReportingServiceBatchChangeSet>
    implements
    MasterDataForGroupReportingServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService service;

    @SuppressWarnings( "deprecation" )
    DefaultMasterDataForGroupReportingServiceBatchChangeSet(
        @Nonnull final DefaultMasterDataForGroupReportingServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultMasterDataForGroupReportingServiceBatchChangeSet getThis()
    {
        return this;
    }

}
