/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationLedger;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ConsolidationLedgerSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationLedger
 * ConsolidationLedger} to other entities. Instances of this object are used in query modifier methods of the entity
 * fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class ConsolidationLedgerLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<ConsolidationLedgerLink<ObjectT>, ConsolidationLedger, ObjectT>
    implements
    ConsolidationLedgerSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public ConsolidationLedgerLink( final String fieldName )
    {
        super(fieldName);
    }

    private ConsolidationLedgerLink(
        final EntityLink<ConsolidationLedgerLink<ObjectT>, ConsolidationLedger, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected ConsolidationLedgerLink<ObjectT> translateLinkType(
        final EntityLink<ConsolidationLedgerLink<ObjectT>, ConsolidationLedger, ObjectT> link )
    {
        return new ConsolidationLedgerLink<ObjectT>(link);
    }

}
