/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.DistributionChannel;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.DistributionChannelSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.DistributionChannel
 * DistributionChannel} to other entities. Instances of this object are used in query modifier methods of the entity
 * fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class DistributionChannelLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<DistributionChannelLink<ObjectT>, DistributionChannel, ObjectT>
    implements
    DistributionChannelSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public DistributionChannelLink( final String fieldName )
    {
        super(fieldName);
    }

    private DistributionChannelLink(
        final EntityLink<DistributionChannelLink<ObjectT>, DistributionChannel, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected DistributionChannelLink<ObjectT> translateLinkType(
        final EntityLink<DistributionChannelLink<ObjectT>, DistributionChannel, ObjectT> link )
    {
        return new DistributionChannelLink<ObjectT>(link);
    }

}
