/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerBusinessArea;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerBusinessAreaSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerBusinessArea
 * PartnerBusinessArea} to other entities. Instances of this object are used in query modifier methods of the entity
 * fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class PartnerBusinessAreaLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<PartnerBusinessAreaLink<ObjectT>, PartnerBusinessArea, ObjectT>
    implements
    PartnerBusinessAreaSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public PartnerBusinessAreaLink( final String fieldName )
    {
        super(fieldName);
    }

    private PartnerBusinessAreaLink(
        final EntityLink<PartnerBusinessAreaLink<ObjectT>, PartnerBusinessArea, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected PartnerBusinessAreaLink<ObjectT> translateLinkType(
        final EntityLink<PartnerBusinessAreaLink<ObjectT>, PartnerBusinessArea, ObjectT> link )
    {
        return new PartnerBusinessAreaLink<ObjectT>(link);
    }

}
