/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SalesOrganizationHier;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SalesOrganizationHierSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SalesOrganizationHier
 * SalesOrganizationHier} to other entities. Instances of this object are used in query modifier methods of the entity
 * fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class SalesOrganizationHierLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<SalesOrganizationHierLink<ObjectT>, SalesOrganizationHier, ObjectT>
    implements
    SalesOrganizationHierSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public SalesOrganizationHierLink( final String fieldName )
    {
        super(fieldName);
    }

    private SalesOrganizationHierLink(
        final EntityLink<SalesOrganizationHierLink<ObjectT>, SalesOrganizationHier, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected SalesOrganizationHierLink<ObjectT> translateLinkType(
        final EntityLink<SalesOrganizationHierLink<ObjectT>, SalesOrganizationHier, ObjectT> link )
    {
        return new SalesOrganizationHierLink<ObjectT>(link);
    }

}
