/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SupplierText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SupplierTextSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SupplierText SupplierText} to
 * other entities. Instances of this object are used in query modifier methods of the entity fluent helpers. Contains
 * methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class SupplierTextLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<SupplierTextLink<ObjectT>, SupplierText, ObjectT>
    implements
    SupplierTextSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public SupplierTextLink( final String fieldName )
    {
        super(fieldName);
    }

    private SupplierTextLink( final EntityLink<SupplierTextLink<ObjectT>, SupplierText, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected SupplierTextLink<ObjectT> translateLinkType(
        final EntityLink<SupplierTextLink<ObjectT>, SupplierText, ObjectT> link )
    {
        return new SupplierTextLink<ObjectT>(link);
    }

}
