/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BaseUnit;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BaseUnit BaseUnit}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.BaseUnitField
 * BaseUnitField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.BaseUnitLink
 * BaseUnitLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BaseUnit#UNIT_OF_MEASURE
 * UNIT_OF_MEASURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BaseUnit#UNIT_OF_MEASURE_TEXT
 * UNIT_OF_MEASURE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BaseUnit#UNIT_OF_MEASURE_ISO_CODE
 * UNIT_OF_MEASURE_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BaseUnit#UNIT_OF_MEASURE_NUMBER_OF_DECIMALS
 * UNIT_OF_MEASURE_NUMBER_OF_DECIMALS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BaseUnit#UNIT_OF_MEASURE_DSP_NMBR_OF_DCMLS
 * UNIT_OF_MEASURE_DSP_NMBR_OF_DCMLS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BaseUnit#UNIT_OF_MEASURE_SAP_CODE
 * UNIT_OF_MEASURE_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BaseUnit#TO_CNSLDTN_BASE_UNIT_T
 * TO_CNSLDTN_BASE_UNIT_T}</li>
 * </ul>
 *
 */
public interface BaseUnitSelectable extends EntitySelectable<BaseUnit>
{

}
