/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BillingDocumentTypeText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BillingDocumentTypeText
 * BillingDocumentTypeText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.BillingDocumentTypeTextField
 * BillingDocumentTypeTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.BillingDocumentTypeTextLink
 * BillingDocumentTypeTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BillingDocumentTypeText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BillingDocumentTypeText#BILLING_DOCUMENT_TYPE
 * BILLING_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BillingDocumentTypeText#BILLING_DOCUMENT_TYPE_TEXT
 * BILLING_DOCUMENT_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BillingDocumentTypeText#TO_CNSLDTN_BILLING_TYPE
 * TO_CNSLDTN_BILLING_TYPE}</li>
 * </ul>
 *
 */
public interface BillingDocumentTypeTextSelectable extends EntitySelectable<BillingDocumentTypeText>
{

}
