/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BreakdownCategoryText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BreakdownCategoryText
 * BreakdownCategoryText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.BreakdownCategoryTextField
 * BreakdownCategoryTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.BreakdownCategoryTextLink
 * BreakdownCategoryTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BreakdownCategoryText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BreakdownCategoryText#CONSOLIDATION_CHART_OF_ACCOUNTS
 * CONSOLIDATION_CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BreakdownCategoryText#CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT
 * CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BreakdownCategoryText#BREAKDOWN_CATEGORY
 * BREAKDOWN_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BreakdownCategoryText#BREAKDOWN_CATEGORY_TEXT
 * BREAKDOWN_CATEGORY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BreakdownCategoryText#TO_CNSLDTN_BREAKDOWN_CATEGORY
 * TO_CNSLDTN_BREAKDOWN_CATEGORY}</li>
 * </ul>
 *
 */
public interface BreakdownCategoryTextSelectable extends EntitySelectable<BreakdownCategoryText>
{

}
