/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnInvesteeUnitText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnInvesteeUnitText
 * CnsldtnInvesteeUnitText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CnsldtnInvesteeUnitTextField
 * CnsldtnInvesteeUnitTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CnsldtnInvesteeUnitTextLink
 * CnsldtnInvesteeUnitTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnInvesteeUnitText#CONSOLIDATION_UNIT
 * CONSOLIDATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnInvesteeUnitText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnInvesteeUnitText#CONSOLIDATION_UNIT_TEXT
 * CONSOLIDATION_UNIT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnInvesteeUnitText#CONSOLIDATION_UNIT_LONG_TEXT
 * CONSOLIDATION_UNIT_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnInvesteeUnitText#TO_CNSLDTN_INVESTEE_UNIT
 * TO_CNSLDTN_INVESTEE_UNIT}</li>
 * </ul>
 *
 */
public interface CnsldtnInvesteeUnitTextSelectable extends EntitySelectable<CnsldtnInvesteeUnitText>
{

}
