/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnOfInvestmentsActivity;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnOfInvestmentsActivity
 * CnsldtnOfInvestmentsActivity}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CnsldtnOfInvestmentsActivityField
 * CnsldtnOfInvestmentsActivityField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CnsldtnOfInvestmentsActivityLink
 * CnsldtnOfInvestmentsActivityLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnOfInvestmentsActivity#INVESTMENT_ACTIVITY_TYPE
 * INVESTMENT_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnOfInvestmentsActivity#INVESTMENT_ACTIVITY_TYPE_TEXT
 * INVESTMENT_ACTIVITY_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnOfInvestmentsActivity#TO_CNSLDTN_OF_INVESTMENTS_ACTY_T
 * TO_CNSLDTN_OF_INVESTMENTS_ACTY_T}</li>
 * </ul>
 *
 */
public interface CnsldtnOfInvestmentsActivitySelectable extends EntitySelectable<CnsldtnOfInvestmentsActivity>
{

}
