/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimText
 * CnsldtnUnitForElimText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CnsldtnUnitForElimTextField
 * CnsldtnUnitForElimTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CnsldtnUnitForElimTextLink
 * CnsldtnUnitForElimTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimText#CONSOLIDATION_UNIT
 * CONSOLIDATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimText#CNSLDTN_UNIT_FOR_ELIM_TEXT
 * CNSLDTN_UNIT_FOR_ELIM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimText#TO_CNSLDTN_UNIT_ELIM
 * TO_CNSLDTN_UNIT_ELIM}</li>
 * </ul>
 *
 */
public interface CnsldtnUnitForElimTextSelectable extends EntitySelectable<CnsldtnUnitForElimText>
{

}
