/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimination;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimination
 * CnsldtnUnitForElimination}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CnsldtnUnitForEliminationField
 * CnsldtnUnitForEliminationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CnsldtnUnitForEliminationLink
 * CnsldtnUnitForEliminationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimination#CONSOLIDATION_UNIT
 * CONSOLIDATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimination#CONSOLIDATION_UNIT_TEXT
 * CONSOLIDATION_UNIT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimination#ADDITIONAL_MASTER_DATA_SOURCE
 * ADDITIONAL_MASTER_DATA_SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimination#CONSOLIDATION_UNIT_LOCAL_CURRENCY
 * CONSOLIDATION_UNIT_LOCAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimination#CONSOLIDATION_UNIT_LOCAL_CURRENCY_TEXT
 * CONSOLIDATION_UNIT_LOCAL_CURRENCY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimination#COUNTRY
 * COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimination#COUNTRY_TEXT
 * COUNTRY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimination#TO_CNSLDTN_UNIT_FOR_ELIMINATION_T
 * TO_CNSLDTN_UNIT_FOR_ELIMINATION_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CnsldtnUnitForElimination#TO_CNSLDTN_UNIT_HIER_FOR_ELIM
 * TO_CNSLDTN_UNIT_HIER_FOR_ELIM}</li>
 * </ul>
 *
 */
public interface CnsldtnUnitForEliminationSelectable extends EntitySelectable<CnsldtnUnitForElimination>
{

}
