/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribText
 * ConsolidationAllMDAttribText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationAllMDAttribTextField
 * ConsolidationAllMDAttribTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationAllMDAttribTextLink
 * ConsolidationAllMDAttribTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribText#CONSOLIDATION_ATTRIBUTE_NAME
 * CONSOLIDATION_ATTRIBUTE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribText#CONSOLIDATION_MD_CHARC_NAME
 * CONSOLIDATION_MD_CHARC_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribText#CONSOLIDATION_ATTRIBUTE_MED_TEXT
 * CONSOLIDATION_ATTRIBUTE_MED_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribText#TO_CNSLDTN_ALL_MD
 * TO_CNSLDTN_ALL_MD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribText#TO_CNSLDTN_ALL_MD_ATTRIBUTE
 * TO_CNSLDTN_ALL_MD_ATTRIBUTE}</li>
 * </ul>
 *
 */
public interface ConsolidationAllMDAttribTextSelectable extends EntitySelectable<ConsolidationAllMDAttribText>
{

}
