/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribute;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribute
 * ConsolidationAllMDAttribute}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationAllMDAttributeField
 * ConsolidationAllMDAttributeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationAllMDAttributeLink
 * ConsolidationAllMDAttributeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribute#CONSOLIDATION_ATTRIBUTE_NAME
 * CONSOLIDATION_ATTRIBUTE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribute#CONSOLIDATION_ATTRIBUTE_NAME_TEXT
 * CONSOLIDATION_ATTRIBUTE_NAME_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribute#CONSOLIDATION_MD_CHARC_NAME
 * CONSOLIDATION_MD_CHARC_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribute#CONSOLIDATION_ATTRIBUTE_SUPRORD
 * CONSOLIDATION_ATTRIBUTE_SUPRORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribute#CONSOLIDATION_ATTRIBUTE_SUPRORD2
 * CONSOLIDATION_ATTRIBUTE_SUPRORD2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribute#CONSOLIDATION_ATTRIBUTE_SUPRORD3
 * CONSOLIDATION_ATTRIBUTE_SUPRORD3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribute#CONSOLIDATION_ATTRIBUTE_SUPRORD4
 * CONSOLIDATION_ATTRIBUTE_SUPRORD4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribute#CONSOLIDATION_ATTRIBUTE_MULTI_VAL
 * CONSOLIDATION_ATTRIBUTE_MULTI_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribute#TO_CNSLDTN_ALL_MD
 * TO_CNSLDTN_ALL_MD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMDAttribute#TO_CNSLDTN_ALL_MD_ATTRIB_T
 * TO_CNSLDTN_ALL_MD_ATTRIB_T}</li>
 * </ul>
 *
 */
public interface ConsolidationAllMDAttributeSelectable extends EntitySelectable<ConsolidationAllMDAttribute>
{

}
