/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMasterData;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMasterData
 * ConsolidationAllMasterData}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationAllMasterDataField
 * ConsolidationAllMasterDataField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationAllMasterDataLink
 * ConsolidationAllMasterDataLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMasterData#ADDITIONAL_CHARC_FIELD_NAME
 * ADDITIONAL_CHARC_FIELD_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMasterData#ADDITIONAL_CHARC_FIELD_NAME_TEXT
 * ADDITIONAL_CHARC_FIELD_NAME_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMasterData#ADDITIONAL_CHARC_IS_IN_USE
 * ADDITIONAL_CHARC_IS_IN_USE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMasterData#ADDITIONAL_MASTER_DATA_IS_IN_USE
 * ADDITIONAL_MASTER_DATA_IS_IN_USE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMasterData#ADDITIONAL_MD_HIERARCHY_IS_IN_USE
 * ADDITIONAL_MD_HIERARCHY_IS_IN_USE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMasterData#CONSOLIDATION_MD_PAIRED_FLD_NAME
 * CONSOLIDATION_MD_PAIRED_FLD_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMasterData#CONSOLIDATION_MD_SUPRORD_FLD_NAME
 * CONSOLIDATION_MD_SUPRORD_FLD_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMasterData#TO_CNSLDTN_ALL_CHARCS_ATTRIBUTE
 * TO_CNSLDTN_ALL_CHARCS_ATTRIBUTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationAllMasterData#TO_CNSLDTN_ALL_MDT
 * TO_CNSLDTN_ALL_MDT}</li>
 * </ul>
 *
 */
public interface ConsolidationAllMasterDataSelectable extends EntitySelectable<ConsolidationAllMasterData>
{

}
