/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationChartOfAccounts;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationChartOfAccounts
 * ConsolidationChartOfAccounts}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationChartOfAccountsField
 * ConsolidationChartOfAccountsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationChartOfAccountsLink
 * ConsolidationChartOfAccountsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationChartOfAccounts#CONSOLIDATION_CHART_OF_ACCOUNTS
 * CONSOLIDATION_CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationChartOfAccounts#CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT
 * CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationChartOfAccounts#TO_CNSLDTN_CHART_OF_ACCOUNTS_T
 * TO_CNSLDTN_CHART_OF_ACCOUNTS_T}</li>
 * </ul>
 *
 */
public interface ConsolidationChartOfAccountsSelectable extends EntitySelectable<ConsolidationChartOfAccounts>
{

}
