/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationChtAcctsText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationChtAcctsText
 * ConsolidationChtAcctsText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationChtAcctsTextField
 * ConsolidationChtAcctsTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationChtAcctsTextLink
 * ConsolidationChtAcctsTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationChtAcctsText#CONSOLIDATION_CHART_OF_ACCOUNTS
 * CONSOLIDATION_CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationChtAcctsText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationChtAcctsText#CONSOLIDATION_CHART_OF_ACCTS_TEXT
 * CONSOLIDATION_CHART_OF_ACCTS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationChtAcctsText#TO_CNSLDTN_CHART_OF_ACCOUNTS
 * TO_CNSLDTN_CHART_OF_ACCOUNTS}</li>
 * </ul>
 *
 */
public interface ConsolidationChtAcctsTextSelectable extends EntitySelectable<ConsolidationChtAcctsText>
{

}
