/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType
 * ConsolidationDocumentType}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationDocumentTypeField
 * ConsolidationDocumentTypeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationDocumentTypeLink
 * ConsolidationDocumentTypeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType#CONSOLIDATION_DOCUMENT_TYPE
 * CONSOLIDATION_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType#CONSOLIDATION_DOCUMENT_TYPE_TEXT
 * CONSOLIDATION_DOCUMENT_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType#POSTING_LEVEL
 * POSTING_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType#POSTING_LEVEL_TEXT
 * POSTING_LEVEL_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType#CONSOLIDATION_BALANCE_CHECK
 * CONSOLIDATION_BALANCE_CHECK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType#CONSOLIDATION_BALANCE_CHECK_TEXT
 * CONSOLIDATION_BALANCE_CHECK_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType#CONSOLIDATION_POSTG_ITEM_AUTO_FLAG
 * CONSOLIDATION_POSTG_ITEM_AUTO_FLAG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType#IS_DOCUMENT_POST_IN_TRANS_CURRENCY
 * IS_DOCUMENT_POST_IN_TRANS_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType#IS_DOCUMENT_POST_IN_LOCAL_CURRENCY
 * IS_DOCUMENT_POST_IN_LOCAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType#IS_DOCUMENT_POST_IN_GROUP_CURRENCY
 * IS_DOCUMENT_POST_IN_GROUP_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType#DOC_HAS_CREDIT_DEFERRED_TAX
 * DOC_HAS_CREDIT_DEFERRED_TAX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType#DOC_HAS_DEBIT_DEFERRED_TAX
 * DOC_HAS_DEBIT_DEFERRED_TAX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType#DOCUMENT_TYPE_BUSINESS_APPL
 * DOCUMENT_TYPE_BUSINESS_APPL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType#DOCUMENT_TYPE_BUSINESS_APPL_TEXT
 * DOCUMENT_TYPE_BUSINESS_APPL_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType#TO_CNSLDTN_DOCUMENT_TYPE_HIER
 * TO_CNSLDTN_DOCUMENT_TYPE_HIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationDocumentType#TO_CNSLDTN_DOCUMENT_TYPE_T
 * TO_CNSLDTN_DOCUMENT_TYPE_T}</li>
 * </ul>
 *
 */
public interface ConsolidationDocumentTypeSelectable extends EntitySelectable<ConsolidationDocumentType>
{

}
