/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationUnit;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationUnit
 * ConsolidationUnit}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationUnitField
 * ConsolidationUnitField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationUnitLink
 * ConsolidationUnitLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationUnit#CONSOLIDATION_UNIT
 * CONSOLIDATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationUnit#CONSOLIDATION_UNIT_TEXT
 * CONSOLIDATION_UNIT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationUnit#CONSOLIDATION_UNIT_LOCAL_CURRENCY
 * CONSOLIDATION_UNIT_LOCAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationUnit#CONSOLIDATION_UNIT_LOCAL_CURRENCY_TEXT
 * CONSOLIDATION_UNIT_LOCAL_CURRENCY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationUnit#COUNTRY
 * COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationUnit#COUNTRY_TEXT
 * COUNTRY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationUnit#TO_CNSLDTN_UNIT_HIER
 * TO_CNSLDTN_UNIT_HIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationUnit#TO_CNSLDTN_UNIT_T
 * TO_CNSLDTN_UNIT_T}</li>
 * </ul>
 *
 */
public interface ConsolidationUnitSelectable extends EntitySelectable<ConsolidationUnit>
{

}
