/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationVersion;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationVersion
 * ConsolidationVersion}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ConsolidationVersionField
 * ConsolidationVersionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ConsolidationVersionLink
 * ConsolidationVersionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationVersion#CONSOLIDATION_VERSION
 * CONSOLIDATION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationVersion#CONSOLIDATION_VERSION_TEXT
 * CONSOLIDATION_VERSION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationVersion#CNSLDTN_REFERENCE_VERSION
 * CNSLDTN_REFERENCE_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationVersion#CNSLDTN_REFERENCE_VERSION_TEXT
 * CNSLDTN_REFERENCE_VERSION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationVersion#GROUP_CURRENCY
 * GROUP_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationVersion#GROUP_CURRENCY_TEXT
 * GROUP_CURRENCY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationVersion#CNSLDTN_IS_PLAN_VERSION
 * CNSLDTN_IS_PLAN_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationVersion#CNSLDTN_VERSION_TYPE
 * CNSLDTN_VERSION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationVersion#CNSLDTN_VERSION_TYPE_TEXT
 * CNSLDTN_VERSION_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationVersion#CNSLDTN_VERSION_RUN_MODE
 * CNSLDTN_VERSION_RUN_MODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationVersion#CNSLDTN_VERSION_HAS_ALL_KEY_FIGURES
 * CNSLDTN_VERSION_HAS_ALL_KEY_FIGURES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ConsolidationVersion#TO_CNSLDTN_VERSION_T
 * TO_CNSLDTN_VERSION_T}</li>
 * </ul>
 *
 */
public interface ConsolidationVersionSelectable extends EntitySelectable<ConsolidationVersion>
{

}
