/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CustomerSupplierCountry;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CustomerSupplierCountry
 * CustomerSupplierCountry}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CustomerSupplierCountryField
 * CustomerSupplierCountryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CustomerSupplierCountryLink
 * CustomerSupplierCountryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CustomerSupplierCountry#COUNTRY
 * COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CustomerSupplierCountry#COUNTRY_TEXT
 * COUNTRY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CustomerSupplierCountry#ADDITIONAL_MASTER_DATA_SOURCE
 * ADDITIONAL_MASTER_DATA_SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CustomerSupplierCountry#TO_CNSLDTN_COUNTRY_HIER
 * TO_CNSLDTN_COUNTRY_HIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CustomerSupplierCountry#TO_CNSLDTN_COUNTRY_T
 * TO_CNSLDTN_COUNTRY_T}</li>
 * </ul>
 *
 */
public interface CustomerSupplierCountrySelectable extends EntitySelectable<CustomerSupplierCountry>
{

}
