/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CustomerSupplierIndustryText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CustomerSupplierIndustryText
 * CustomerSupplierIndustryText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.CustomerSupplierIndustryTextField
 * CustomerSupplierIndustryTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.CustomerSupplierIndustryTextLink
 * CustomerSupplierIndustryTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CustomerSupplierIndustryText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CustomerSupplierIndustryText#INDUSTRY
 * INDUSTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CustomerSupplierIndustryText#CUSTOMER_SUPPLIER_INDUSTRY_TEXT
 * CUSTOMER_SUPPLIER_INDUSTRY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.CustomerSupplierIndustryText#TO_CNSLDTN_INDUSTRY
 * TO_CNSLDTN_INDUSTRY}</li>
 * </ul>
 *
 */
public interface CustomerSupplierIndustryTextSelectable extends EntitySelectable<CustomerSupplierIndustryText>
{

}
