/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion
 * FSItemAttribByTimeVersion}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FSItemAttribByTimeVersionField
 * FSItemAttribByTimeVersionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FSItemAttribByTimeVersionLink
 * FSItemAttribByTimeVersionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#CONSOLIDATION_CHART_OF_ACCOUNTS
 * CONSOLIDATION_CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT
 * CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FINANCIAL_STATEMENT_ITEM
 * FINANCIAL_STATEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FINANCIAL_STATEMENT_ITEM_TEXT
 * FINANCIAL_STATEMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#CONSOLIDATION_VERSION
 * CONSOLIDATION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#CONSOLIDATION_VERSION_TEXT
 * CONSOLIDATION_VERSION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FROM_FISCAL_YEAR_PERIOD
 * FROM_FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#TO_FISCAL_YEAR_PERIOD
 * TO_FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FINANCIAL_STATEMENT_ITEM_ROLE
 * FINANCIAL_STATEMENT_ITEM_ROLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FS_ITEM_ROLE_TEXT
 * FS_ITEM_ROLE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FS_ITEM_DATA_COLLECTION
 * FS_ITEM_DATA_COLLECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FS_ITEM_DATA_COLLECTION_TEXT
 * FS_ITEM_DATA_COLLECTION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FS_ITEM_CURRENCY_TRANSLATION
 * FS_ITEM_CURRENCY_TRANSLATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FS_ITEM_CURRENCY_TRANSLATION_TEXT
 * FS_ITEM_CURRENCY_TRANSLATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FS_ITEM_ELIMINATION
 * FS_ITEM_ELIMINATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FS_ITEM_ELIMINATION_TEXT
 * FS_ITEM_ELIMINATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FS_ITEM_CASH_FLOW
 * FS_ITEM_CASH_FLOW}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FS_ITEM_CASH_FLOW_TEXT
 * FS_ITEM_CASH_FLOW_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FS_ITEM_SCOPE
 * FS_ITEM_SCOPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FS_ITEM_SCOPE_TEXT
 * FS_ITEM_SCOPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FS_ITEM_CUSTOMER_SPECIFIC
 * FS_ITEM_CUSTOMER_SPECIFIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#FS_ITEM_CUSTOMER_SPECIFIC_TEXT
 * FS_ITEM_CUSTOMER_SPECIFIC_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#ELIMINATION_TARGET_FS_ITEM
 * ELIMINATION_TARGET_FS_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#ELIMINATION_TARGET_FS_ITEM_TEXT
 * ELIMINATION_TARGET_FS_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#NCI_TARGET_FS_ITEM
 * NCI_TARGET_FS_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#NCI_TARGET_FS_ITEM_TEXT
 * NCI_TARGET_FS_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#PLANNING_TARGET_FS_ITEM
 * PLANNING_TARGET_FS_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#PLANNING_TARGET_FS_ITEM_TEXT
 * PLANNING_TARGET_FS_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#CNSLDTN_OFFSETTING_TARGET_FS_ITEM
 * CNSLDTN_OFFSETTING_TARGET_FS_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#CNSLDTN_OFFSTG_TARGET_FS_ITEM_TEXT
 * CNSLDTN_OFFSTG_TARGET_FS_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemAttribByTimeVersion#TO_CNSLDTN_FS_ITEM
 * TO_CNSLDTN_FS_ITEM}</li>
 * </ul>
 *
 */
public interface FSItemAttribByTimeVersionSelectable extends EntitySelectable<FSItemAttribByTimeVersion>
{

}
