/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttrib;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttrib
 * FSItemSelectionAttrib}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FSItemSelectionAttribField
 * FSItemSelectionAttribField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FSItemSelectionAttribLink
 * FSItemSelectionAttribLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttrib#FS_ITEM_ATTRIBUTE_NAME
 * FS_ITEM_ATTRIBUTE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttrib#FS_ITEM_ATTRIBUTE_NAME_TEXT
 * FS_ITEM_ATTRIBUTE_NAME_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttrib#TO_CNSLDTN_FS_ITEM_SEL_ATTRIB_T
 * TO_CNSLDTN_FS_ITEM_SEL_ATTRIB_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttrib#TO_CNSLDTN_FS_ITEM_SEL_ATTRIB_VAL
 * TO_CNSLDTN_FS_ITEM_SEL_ATTRIB_VAL}</li>
 * </ul>
 *
 */
public interface FSItemSelectionAttribSelectable extends EntitySelectable<FSItemSelectionAttrib>
{

}
