/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribText
 * FSItemSelectionAttribText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FSItemSelectionAttribTextField
 * FSItemSelectionAttribTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FSItemSelectionAttribTextLink
 * FSItemSelectionAttribTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribText#FS_ITEM_ATTRIBUTE_NAME
 * FS_ITEM_ATTRIBUTE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribText#FS_ITEM_ATTRIBUTE_TEXT
 * FS_ITEM_ATTRIBUTE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribText#TO_CNSLDTN_FS_ITEM_SEL_ATTRIB
 * TO_CNSLDTN_FS_ITEM_SEL_ATTRIB}</li>
 * </ul>
 *
 */
public interface FSItemSelectionAttribTextSelectable extends EntitySelectable<FSItemSelectionAttribText>
{

}
