/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribVal;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribVal
 * FSItemSelectionAttribVal}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FSItemSelectionAttribValField
 * FSItemSelectionAttribValField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FSItemSelectionAttribValLink
 * FSItemSelectionAttribValLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribVal#FS_ITEM_ATTRIBUTE_NAME
 * FS_ITEM_ATTRIBUTE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribVal#FS_ITEM_ATTRIBUTE_NAME_TEXT
 * FS_ITEM_ATTRIBUTE_NAME_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribVal#FS_ITEM_ATTRIBUTE_VALUE_NAME
 * FS_ITEM_ATTRIBUTE_VALUE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribVal#FS_ITEM_ATTRIBUTE_VALUE_NAME_TEXT
 * FS_ITEM_ATTRIBUTE_VALUE_NAME_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribVal#TO_CNSLDTN_FS_ITEM_SEL_ATTRIB_VAL_T
 * TO_CNSLDTN_FS_ITEM_SEL_ATTRIB_VAL_T}</li>
 * </ul>
 *
 */
public interface FSItemSelectionAttribValSelectable extends EntitySelectable<FSItemSelectionAttribVal>
{

}
