/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribValText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribValText
 * FSItemSelectionAttribValText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FSItemSelectionAttribValTextField
 * FSItemSelectionAttribValTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FSItemSelectionAttribValTextLink
 * FSItemSelectionAttribValTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribValText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribValText#FS_ITEM_ATTRIBUTE_NAME
 * FS_ITEM_ATTRIBUTE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribValText#FS_ITEM_ATTRIBUTE_NAME_TEXT
 * FS_ITEM_ATTRIBUTE_NAME_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribValText#FS_ITEM_ATTRIBUTE_VALUE_NAME
 * FS_ITEM_ATTRIBUTE_VALUE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribValText#FS_ITEM_ATTRIBUTE_VALUE_TEXT
 * FS_ITEM_ATTRIBUTE_VALUE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribValText#FS_ITEM_ATTRIBUTE_VALUE_LONG_TEXT
 * FS_ITEM_ATTRIBUTE_VALUE_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemSelectionAttribValText#TO_CNSLDTN_FS_ITEM_SEL_ATTRIB_VAL
 * TO_CNSLDTN_FS_ITEM_SEL_ATTRIB_VAL}</li>
 * </ul>
 *
 */
public interface FSItemSelectionAttribValTextSelectable extends EntitySelectable<FSItemSelectionAttribValText>
{

}
