/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemTargetAttrib;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemTargetAttrib
 * FSItemTargetAttrib}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FSItemTargetAttribField
 * FSItemTargetAttribField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FSItemTargetAttribLink
 * FSItemTargetAttribLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemTargetAttrib#FS_ITEM_ATTRIBUTE_NAME
 * FS_ITEM_ATTRIBUTE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemTargetAttrib#FS_ITEM_ATTRIBUTE_NAME_TEXT
 * FS_ITEM_ATTRIBUTE_NAME_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemTargetAttrib#TO_CNSLDTN_FS_ITEM_TGT_ATTRIB_T
 * TO_CNSLDTN_FS_ITEM_TGT_ATTRIB_T}</li>
 * </ul>
 *
 */
public interface FSItemTargetAttribSelectable extends EntitySelectable<FSItemTargetAttrib>
{

}
