/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemTypeText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemTypeText
 * FSItemTypeText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FSItemTypeTextField
 * FSItemTypeTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FSItemTypeTextLink
 * FSItemTypeTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemTypeText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemTypeText#FINANCIAL_STATEMENT_ITEM_TYPE
 * FINANCIAL_STATEMENT_ITEM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemTypeText#FINANCIAL_STATEMENT_ITEM_TYPE_TEXT
 * FINANCIAL_STATEMENT_ITEM_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FSItemTypeText#TO_CNSLDTN_FS_ITEM_TYPE
 * TO_CNSLDTN_FS_ITEM_TYPE}</li>
 * </ul>
 *
 */
public interface FSItemTypeTextSelectable extends EntitySelectable<FSItemTypeText>
{

}
