/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemHier;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemHier
 * FinancialStatementItemHier}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FinancialStatementItemHierField
 * FinancialStatementItemHierField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FinancialStatementItemHierLink
 * FinancialStatementItemHierLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemHier#CONSOLIDATION_CHART_OF_ACCOUNTS
 * CONSOLIDATION_CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemHier#CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT
 * CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemHier#FINANCIAL_STATEMENT_ITEM_HIER
 * FINANCIAL_STATEMENT_ITEM_HIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemHier#HIERARCHY_NODE
 * HIERARCHY_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemHier#HIERARCHY_NODE_TEXT
 * HIERARCHY_NODE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemHier#PARENT_NODE
 * PARENT_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemHier#HIERARCHY_VERSION
 * HIERARCHY_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemHier#FINANCIAL_STATEMENT_ITEM
 * FINANCIAL_STATEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemHier#FINANCIAL_STATEMENT_ITEM_TEXT
 * FINANCIAL_STATEMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemHier#SEQUENCE_NUMBER
 * SEQUENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemHier#HIERARCHY_NODE_LEVEL
 * HIERARCHY_NODE_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemHier#NODE_TYPE
 * NODE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemHier#TO_CNSLDTN_FS_ITEM
 * TO_CNSLDTN_FS_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemHier#TO_CNSLDTN_FS_ITEM_HIER_T
 * TO_CNSLDTN_FS_ITEM_HIER_T}</li>
 * </ul>
 *
 */
public interface FinancialStatementItemHierSelectable extends EntitySelectable<FinancialStatementItemHier>
{

}
