/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem
 * FinancialStatementItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FinancialStatementItemField
 * FinancialStatementItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FinancialStatementItemLink
 * FinancialStatementItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#CONSOLIDATION_CHART_OF_ACCOUNTS
 * CONSOLIDATION_CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT
 * CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FINANCIAL_STATEMENT_ITEM
 * FINANCIAL_STATEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FINANCIAL_STATEMENT_ITEM_TEXT
 * FINANCIAL_STATEMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#CONSOLIDATION_FS_ITEM_TYPE
 * CONSOLIDATION_FS_ITEM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#CONSOLIDATION_FS_ITEM_TYPE_TEXT
 * CONSOLIDATION_FS_ITEM_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#BREAKDOWN_CATEGORY
 * BREAKDOWN_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#BREAKDOWN_CATEGORY_TEXT
 * BREAKDOWN_CATEGORY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#IS_CONSOLIDATION_ITEM
 * IS_CONSOLIDATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FINANCIAL_STATEMENT_ITEM_IS_BLKD
 * FINANCIAL_STATEMENT_ITEM_IS_BLKD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FS_ITEM_ELIMINATION
 * FS_ITEM_ELIMINATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FS_ITEM_ELIMINATION_TEXT
 * FS_ITEM_ELIMINATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FS_ITEM_CURRENCY_TRANSLATION
 * FS_ITEM_CURRENCY_TRANSLATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FS_ITEM_CURRENCY_TRANSLATION_TEXT
 * FS_ITEM_CURRENCY_TRANSLATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FINANCIAL_STATEMENT_ITEM_ROLE
 * FINANCIAL_STATEMENT_ITEM_ROLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FS_ITEM_ROLE_TEXT
 * FS_ITEM_ROLE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FS_ITEM_DATA_COLLECTION
 * FS_ITEM_DATA_COLLECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FS_ITEM_DATA_COLLECTION_TEXT
 * FS_ITEM_DATA_COLLECTION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FS_ITEM_CASH_FLOW
 * FS_ITEM_CASH_FLOW}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FS_ITEM_CASH_FLOW_TEXT
 * FS_ITEM_CASH_FLOW_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FS_ITEM_SCOPE
 * FS_ITEM_SCOPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FS_ITEM_SCOPE_TEXT
 * FS_ITEM_SCOPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FS_ITEM_CUSTOMER_SPECIFIC
 * FS_ITEM_CUSTOMER_SPECIFIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#FS_ITEM_CUSTOMER_SPECIFIC_TEXT
 * FS_ITEM_CUSTOMER_SPECIFIC_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#ELIMINATION_TARGET_FS_ITEM
 * ELIMINATION_TARGET_FS_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#ELIMINATION_TARGET_FS_ITEM_TEXT
 * ELIMINATION_TARGET_FS_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#NCI_TARGET_FS_ITEM
 * NCI_TARGET_FS_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#NCI_TARGET_FS_ITEM_TEXT
 * NCI_TARGET_FS_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#PLANNING_TARGET_FS_ITEM
 * PLANNING_TARGET_FS_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#PLANNING_TARGET_FS_ITEM_TEXT
 * PLANNING_TARGET_FS_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#CNSLDTN_OFFSETTING_TARGET_FS_ITEM
 * CNSLDTN_OFFSETTING_TARGET_FS_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#CNSLDTN_OFFSTG_TARGET_FS_ITEM_TEXT
 * CNSLDTN_OFFSTG_TARGET_FS_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#TO_CNSLDTN_FS_ITEM_HIER
 * TO_CNSLDTN_FS_ITEM_HIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItem#TO_CNSLDTN_FS_ITEM_T
 * TO_CNSLDTN_FS_ITEM_T}</li>
 * </ul>
 *
 */
public interface FinancialStatementItemSelectable extends EntitySelectable<FinancialStatementItem>
{

}
