/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemText
 * FinancialStatementItemText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FinancialStatementItemTextField
 * FinancialStatementItemTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FinancialStatementItemTextLink
 * FinancialStatementItemTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemText#CONSOLIDATION_CHART_OF_ACCOUNTS
 * CONSOLIDATION_CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemText#CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT
 * CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemText#FINANCIAL_STATEMENT_ITEM
 * FINANCIAL_STATEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemText#FINANCIAL_STATEMENT_ITEM_TEXT
 * FINANCIAL_STATEMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialStatementItemText#TO_CNSLDTN_FS_ITEM
 * TO_CNSLDTN_FS_ITEM}</li>
 * </ul>
 *
 */
public interface FinancialStatementItemTextSelectable extends EntitySelectable<FinancialStatementItemText>
{

}
