/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialTransactionType;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialTransactionType
 * FinancialTransactionType}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.FinancialTransactionTypeField
 * FinancialTransactionTypeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.FinancialTransactionTypeLink
 * FinancialTransactionTypeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialTransactionType#FINANCIAL_TRANSACTION_TYPE
 * FINANCIAL_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialTransactionType#FINANCIAL_TRANSACTION_TYPE_TEXT
 * FINANCIAL_TRANSACTION_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialTransactionType#ADDITIONAL_MASTER_DATA_SOURCE
 * ADDITIONAL_MASTER_DATA_SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialTransactionType#TO_CNSLDTN_FIN_TRANS_TYPE_HIER
 * TO_CNSLDTN_FIN_TRANS_TYPE_HIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.FinancialTransactionType#TO_CNSLDTN_FIN_TRANS_TYPE_T
 * TO_CNSLDTN_FIN_TRANS_TYPE_T}</li>
 * </ul>
 *
 */
public interface FinancialTransactionTypeSelectable extends EntitySelectable<FinancialTransactionType>
{

}
