/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.InvestmentActivityType;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.InvestmentActivityType
 * InvestmentActivityType}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.InvestmentActivityTypeField
 * InvestmentActivityTypeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.InvestmentActivityTypeLink
 * InvestmentActivityTypeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.InvestmentActivityType#INVESTMENT_ACTIVITY_TYPE
 * INVESTMENT_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.InvestmentActivityType#INVESTMENT_ACTIVITY_TYPE_TEXT
 * INVESTMENT_ACTIVITY_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.InvestmentActivityType#TO_CNSLDTN_INVMT_ACTY_TYPE_T
 * TO_CNSLDTN_INVMT_ACTY_TYPE_T}</li>
 * </ul>
 *
 */
public interface InvestmentActivityTypeSelectable extends EntitySelectable<InvestmentActivityType>
{

}
