/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.InvestmentActivityTypeText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.InvestmentActivityTypeText
 * InvestmentActivityTypeText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.InvestmentActivityTypeTextField
 * InvestmentActivityTypeTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.InvestmentActivityTypeTextLink
 * InvestmentActivityTypeTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.InvestmentActivityTypeText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.InvestmentActivityTypeText#INVESTMENT_ACTIVITY_TYPE
 * INVESTMENT_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.InvestmentActivityTypeText#INVESTMENT_ACTIVITY_TYPE_TEXT
 * INVESTMENT_ACTIVITY_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.InvestmentActivityTypeText#TO_CNSLDTN_INVMT_ACTY_TYPE
 * TO_CNSLDTN_INVMT_ACTY_TYPE}</li>
 * </ul>
 *
 */
public interface InvestmentActivityTypeTextSelectable extends EntitySelectable<InvestmentActivityTypeText>
{

}
