/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.MaterialGroup;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.MaterialGroup MaterialGroup}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.MaterialGroupField
 * MaterialGroupField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.MaterialGroupLink
 * MaterialGroupLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.MaterialGroup#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.MaterialGroup#MATERIAL_GROUP_TEXT
 * MATERIAL_GROUP_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.MaterialGroup#ADDITIONAL_MASTER_DATA_SOURCE
 * ADDITIONAL_MASTER_DATA_SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.MaterialGroup#TO_CNSLDTN_MATERIAL_GROUP_HIER
 * TO_CNSLDTN_MATERIAL_GROUP_HIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.MaterialGroup#TO_CNSLDTN_MATERIAL_GROUP_T
 * TO_CNSLDTN_MATERIAL_GROUP_T}</li>
 * </ul>
 *
 */
public interface MaterialGroupSelectable extends EntitySelectable<MaterialGroup>
{

}
