/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerCompanyText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerCompanyText
 * PartnerCompanyText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PartnerCompanyTextField
 * PartnerCompanyTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerCompanyTextLink
 * PartnerCompanyTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerCompanyText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerCompanyText#COMPANY
 * COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerCompanyText#ADDITIONAL_MASTER_DATA_SOURCE
 * ADDITIONAL_MASTER_DATA_SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerCompanyText#PARTNER_COMPANY_TEXT
 * PARTNER_COMPANY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerCompanyText#TO_CNSLDTN_GLOBAL_COMPANY
 * TO_CNSLDTN_GLOBAL_COMPANY}</li>
 * </ul>
 *
 */
public interface PartnerCompanyTextSelectable extends EntitySelectable<PartnerCompanyText>
{

}
