/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerFunctionalAreaText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerFunctionalAreaText
 * PartnerFunctionalAreaText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PartnerFunctionalAreaTextField
 * PartnerFunctionalAreaTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerFunctionalAreaTextLink
 * PartnerFunctionalAreaTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerFunctionalAreaText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerFunctionalAreaText#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerFunctionalAreaText#PARTNER_FUNCTIONAL_AREA_TEXT
 * PARTNER_FUNCTIONAL_AREA_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerFunctionalAreaText#TO_CNSLDTN_PARTNER_FUNCNL_AREA
 * TO_CNSLDTN_PARTNER_FUNCNL_AREA}</li>
 * </ul>
 *
 */
public interface PartnerFunctionalAreaTextSelectable extends EntitySelectable<PartnerFunctionalAreaText>
{

}
