/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim
 * ProfitCenterHierForElim}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ProfitCenterHierForElimField
 * ProfitCenterHierForElimField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ProfitCenterHierForElimLink
 * ProfitCenterHierForElimLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim#ADDITIONAL_MASTER_DATA_HIERARCHY
 * ADDITIONAL_MASTER_DATA_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim#HIERARCHY_NODE
 * HIERARCHY_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim#HIERARCHY_NODE_TEXT
 * HIERARCHY_NODE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim#PARENT_NODE
 * PARENT_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim#HIERARCHY_VERSION
 * HIERARCHY_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim#PROFIT_CENTER_TEXT
 * PROFIT_CENTER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim#SEQUENCE_NUMBER
 * SEQUENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim#HIERARCHY_NODE_SEQUENCE
 * HIERARCHY_NODE_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim#HIERARCHY_NODE_LEVEL
 * HIERARCHY_NODE_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim#NODE_TYPE
 * NODE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim#TO_CNSLDTN_PRFT_CTR_FOR_ELIM
 * TO_CNSLDTN_PRFT_CTR_FOR_ELIM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierForElim#TO_CNSLDTN_PRFT_CTR_HIER_FOR_ELIM_T
 * TO_CNSLDTN_PRFT_CTR_HIER_FOR_ELIM_T}</li>
 * </ul>
 *
 */
public interface ProfitCenterHierForElimSelectable extends EntitySelectable<ProfitCenterHierForElim>
{

}
