/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier
 * ProfitCenterHier}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ProfitCenterHierField
 * ProfitCenterHierField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ProfitCenterHierLink
 * ProfitCenterHierLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier#ADDITIONAL_MASTER_DATA_HIERARCHY
 * ADDITIONAL_MASTER_DATA_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier#HIERARCHY_NODE
 * HIERARCHY_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier#HIERARCHY_NODE_TEXT
 * HIERARCHY_NODE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier#PARENT_NODE
 * PARENT_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier#HIERARCHY_VERSION
 * HIERARCHY_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier#PROFIT_CENTER_TEXT
 * PROFIT_CENTER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier#SEQUENCE_NUMBER
 * SEQUENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier#HIERARCHY_NODE_SEQUENCE
 * HIERARCHY_NODE_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier#HIERARCHY_NODE_LEVEL
 * HIERARCHY_NODE_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier#NODE_TYPE
 * NODE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier#TO_CNSLDTN_PROFIT_CENTER
 * TO_CNSLDTN_PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier#TO_CNSLDTN_PROFIT_CENTER_HIER_T
 * TO_CNSLDTN_PROFIT_CENTER_HIER_T}</li>
 * </ul>
 *
 */
public interface ProfitCenterHierSelectable extends EntitySelectable<ProfitCenterHier>
{

}
