/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenter;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenter ProfitCenter}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ProfitCenterField
 * ProfitCenterField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ProfitCenterLink
 * ProfitCenterLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenter#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenter#PROFIT_CENTER_TEXT
 * PROFIT_CENTER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenter#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenter#ADDITIONAL_MASTER_DATA_SOURCE
 * ADDITIONAL_MASTER_DATA_SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenter#TO_CNSLDTN_PROFIT_CENTER_HIER
 * TO_CNSLDTN_PROFIT_CENTER_HIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenter#TO_CNSLDTN_PROFIT_CENTER_T
 * TO_CNSLDTN_PROFIT_CENTER_T}</li>
 * </ul>
 *
 */
public interface ProfitCenterSelectable extends EntitySelectable<ProfitCenter>
{

}
