/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SegmentHierText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SegmentHierText
 * SegmentHierText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SegmentHierTextField
 * SegmentHierTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SegmentHierTextLink
 * SegmentHierTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SegmentHierText#CONSOLIDATION_SEGMENT_HIERARCHY
 * CONSOLIDATION_SEGMENT_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SegmentHierText#HIERARCHY_NODE
 * HIERARCHY_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SegmentHierText#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SegmentHierText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SegmentHierText#HIERARCHY_NODE_TEXT
 * HIERARCHY_NODE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SegmentHierText#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SegmentHierText#NODE_TYPE
 * NODE_TYPE}</li>
 * </ul>
 *
 */
public interface SegmentHierTextSelectable extends EntitySelectable<SegmentHierText>
{

}
