/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SubItemCategory;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SubItemCategory
 * SubItemCategory}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SubItemCategoryField
 * SubItemCategoryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SubItemCategoryLink
 * SubItemCategoryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SubItemCategory#SUB_ITEM_CATEGORY
 * SUB_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SubItemCategory#SUB_ITEM_CATEGORY_TEXT
 * SUB_ITEM_CATEGORY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SubItemCategory#IS_SUB_ITEMS_FOR_ACQUISITIONS_DIVES
 * IS_SUB_ITEMS_FOR_ACQUISITIONS_DIVES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SubItemCategory#TO_CNSLDTN_SUBITEM_CATEGORY_T
 * TO_CNSLDTN_SUBITEM_CATEGORY_T}</li>
 * </ul>
 *
 */
public interface SubItemCategorySelectable extends EntitySelectable<SubItemCategory>
{

}
