/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SubassignmentText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SubassignmentText
 * SubassignmentText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SubassignmentTextField
 * SubassignmentTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SubassignmentTextLink
 * SubassignmentTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SubassignmentText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SubassignmentText#CNSLDTN_SUBASSIGNMENT
 * CNSLDTN_SUBASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SubassignmentText#CNSLDTN_SUBASSIGNMENT_TEXT
 * CNSLDTN_SUBASSIGNMENT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SubassignmentText#TO_CNSLDTN_SUBASSIGNMENT
 * TO_CNSLDTN_SUBASSIGNMENT}</li>
 * </ul>
 *
 */
public interface SubassignmentTextSelectable extends EntitySelectable<SubassignmentText>
{

}
