/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.TransactionCurrencyText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.TransactionCurrencyText
 * TransactionCurrencyText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.TransactionCurrencyTextField
 * TransactionCurrencyTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.TransactionCurrencyTextLink
 * TransactionCurrencyTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.TransactionCurrencyText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.TransactionCurrencyText#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.TransactionCurrencyText#TRANSACTION_CURRENCY_TEXT
 * TRANSACTION_CURRENCY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.TransactionCurrencyText#TO_CNSLDTN_TRANSACTION_CURRENCY
 * TO_CNSLDTN_TRANSACTION_CURRENCY}</li>
 * </ul>
 *
 */
public interface TransactionCurrencyTextSelectable extends EntitySelectable<TransactionCurrencyText>
{

}
