/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID
 * WBSElementInternalID}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.WBSElementInternalIDField
 * WBSElementInternalIDField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.WBSElementInternalIDLink
 * WBSElementInternalIDLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_ELEMENT_INTERNAL_ID
 * WBS_ELEMENT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#PROJECT_INTERNAL_ID
 * PROJECT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_DESCRIPTION
 * WBS_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_ELEMENT_OBJECT
 * WBS_ELEMENT_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#RESPONSIBLE_PERSON
 * RESPONSIBLE_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#RESPONSIBLE_PERSON_NAME
 * RESPONSIBLE_PERSON_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#APPLICANT_CODE
 * APPLICANT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#APPLICANT_NAME
 * APPLICANT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#PROJECT_TYPE
 * PROJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_ELEMENT_IS_PLANNING_ELEMENT
 * WBS_ELEMENT_IS_PLANNING_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_IS_ACCOUNT_ASSIGNMENT_ELEMENT
 * WBS_IS_ACCOUNT_ASSIGNMENT_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_ELEMENT_IS_BILLING_ELEMENT
 * WBS_ELEMENT_IS_BILLING_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#COSTING_SHEET
 * COSTING_SHEET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#REQUESTING_COST_CENTER
 * REQUESTING_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#RESPONSIBLE_COST_CENTER
 * RESPONSIBLE_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FACTORY_CALENDAR
 * FACTORY_CALENDAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#PRIORITY_CODE
 * PRIORITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_TABLE_FIELD_SEMANTIC
 * FREE_DEFINED_TABLE_FIELD_SEMANTIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_IS_STATISTICAL_WBS_ELEMENT
 * WBS_IS_STATISTICAL_WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_IS_MARKED_FOR_INTEGRATED_PLNG
 * WBS_IS_MARKED_FOR_INTEGRATED_PLNG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#LOCATION
 * LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#EQUIPMENT
 * EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FUNCTIONAL_LOCATION
 * FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#PROJECT_OBJECT_CHANGE_NUMBER
 * PROJECT_OBJECT_CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#PROJECT_OBJECT_REFERENCE_ELEMENT
 * PROJECT_OBJECT_REFERENCE_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#PROJ_INTEREST_CALC_PROFILE
 * PROJ_INTEREST_CALC_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#INVESTMENT_PROFILE
 * INVESTMENT_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#BASIC_START_DATE
 * BASIC_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FORECASTED_START_DATE
 * FORECASTED_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#ACTUAL_START_DATE
 * ACTUAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#BASIC_END_DATE
 * BASIC_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FORECASTED_END_DATE
 * FORECASTED_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#ACTUAL_END_DATE
 * ACTUAL_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#ACTUAL_DURATION_UNIT
 * ACTUAL_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FORECASTED_DURATION_UNIT
 * FORECASTED_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#BASIC_DURATION_UNIT
 * BASIC_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#BASIC_DURATION
 * BASIC_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FORECASTED_DURATION
 * FORECASTED_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#ACTUAL_DURATION
 * ACTUAL_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#SCHEDLD_BASIC_EARLIEST_START_DATE
 * SCHEDLD_BASIC_EARLIEST_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#SCHEDULED_BASIC_LATEST_END_DATE
 * SCHEDULED_BASIC_LATEST_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#SCHEDLD_FCSTD_EARLIEST_START_DATE
 * SCHEDLD_FCSTD_EARLIEST_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#LATEST_SCHEDLD_FCSTD_END_DATE
 * LATEST_SCHEDLD_FCSTD_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#TENTATIVE_ACTUAL_START_DATE
 * TENTATIVE_ACTUAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#TENTATIVE_ACTUAL_END_DATE
 * TENTATIVE_ACTUAL_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#SCHEDLD_BASIC_LATEST_START_DATE
 * SCHEDLD_BASIC_LATEST_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#SCHEDLD_BASIC_EARLIEST_END_DATE
 * SCHEDLD_BASIC_EARLIEST_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#LATEST_SCHEDLD_FCSTD_START_DATE
 * LATEST_SCHEDLD_FCSTD_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#SCHEDLD_FCSTD_EARLIEST_END_DATE
 * SCHEDLD_FCSTD_EARLIEST_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_ELEMENT_HIERARCHY_LEVEL
 * WBS_ELEMENT_HIERARCHY_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#OVERHEAD_CODE
 * OVERHEAD_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#RESULT_ANALYSIS_INTERNAL_ID
 * RESULT_ANALYSIS_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#PROGRESS_ANLYS_AGGREGATION_WEIGHT
 * PROGRESS_ANLYS_AGGREGATION_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_ELEMENT_SHORT_ID
 * WBS_ELEMENT_SHORT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#REQG_COST_CENTER_CONTROLLING_AREA
 * REQG_COST_CENTER_CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#RESP_COST_CENTER_CONTROLLING_AREA
 * RESP_COST_CENTER_CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#COST_OBJECT
 * COST_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_ELEMENT_IS_USED_IN_PROJ_SMMRY
 * WBS_ELEMENT_IS_USED_IN_PROJ_SMMRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#INVENTORY_SPECIAL_STOCK_VALN_TYPE
 * INVENTORY_SPECIAL_STOCK_VALN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#BILLING_PLAN
 * BILLING_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_ELEMENT_IS_GROUPING_WBS_ELEMENT
 * WBS_ELEMENT_IS_GROUPING_WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#COSTING_VARIANT
 * COSTING_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#JOINT_VENTURE
 * JOINT_VENTURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#JOINT_VENTURE_RECOVERY_CODE
 * JOINT_VENTURE_RECOVERY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#JOINT_VENTURE_EQUITY_TYPE
 * JOINT_VENTURE_EQUITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#JOINT_VENTURE_OBJECT_TYPE
 * JOINT_VENTURE_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#JOINT_VENTURE_CLASS
 * JOINT_VENTURE_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#JOINT_VENTURE_SUB_CLASS
 * JOINT_VENTURE_SUB_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_ELEMENT_HAS_ACTIVITIES
 * WBS_ELEMENT_HAS_ACTIVITIES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_HAS_FCSTD_DATE_FROM_ACTIVITY
 * WBS_HAS_FCSTD_DATE_FROM_ACTIVITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_HAS_FCSTD_DATE_SET_MANUALLY
 * WBS_HAS_FCSTD_DATE_SET_MANUALLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_HAS_BASIC_DATE_MANUALLY_SET
 * WBS_HAS_BASIC_DATE_MANUALLY_SET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_HAS_ACTUAL_DATE_SET_MANUALLY
 * WBS_HAS_ACTUAL_DATE_SET_MANUALLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#WBS_ELMNT_HAS_ACTUAL_DATE_FROM_ACTY
 * WBS_ELMNT_HAS_ACTUAL_DATE_FROM_ACTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#CONTROLLING_OBJECT_CLASS
 * CONTROLLING_OBJECT_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_ATTRIBUTE01
 * FREE_DEFINED_ATTRIBUTE01}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_ATTRIBUTE02
 * FREE_DEFINED_ATTRIBUTE02}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_ATTRIBUTE03
 * FREE_DEFINED_ATTRIBUTE03}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_ATTRIBUTE04
 * FREE_DEFINED_ATTRIBUTE04}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_QUANTITY1
 * FREE_DEFINED_QUANTITY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_QUANTITY1_UNIT
 * FREE_DEFINED_QUANTITY1_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_QUANTITY2
 * FREE_DEFINED_QUANTITY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_QUANTITY2_UNIT
 * FREE_DEFINED_QUANTITY2_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_AMOUNT1
 * FREE_DEFINED_AMOUNT1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_AMOUNT1_CURRENCY
 * FREE_DEFINED_AMOUNT1_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_AMOUNT2
 * FREE_DEFINED_AMOUNT2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_AMOUNT2_CURRENCY
 * FREE_DEFINED_AMOUNT2_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_DATE1
 * FREE_DEFINED_DATE1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_DATE2
 * FREE_DEFINED_DATE2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_INDICATOR1
 * FREE_DEFINED_INDICATOR1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID#FREE_DEFINED_INDICATOR2
 * FREE_DEFINED_INDICATOR2}</li>
 * </ul>
 *
 */
public interface WBSElementInternalIDSelectable extends EntitySelectable<WBSElementInternalID>
{

}
