/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.field.InspectionSpecificationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.link.InspectionSpecificationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterinspectioncharacteristic.selectable.InspectionSpecificationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Master Inspection Characteristics
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_InspectionSpecificationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class InspectionSpecification extends VdmEntity<InspectionSpecification>
{

    /**
     * Selector for all available fields of InspectionSpecification.
     *
     */
    public final static InspectionSpecificationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecification</b>
     * </p>
     *
     * @return Master Inspection Characteristic
     */
    @Key
    @SerializedName( "InspectionSpecification" )
    @JsonProperty( "InspectionSpecification" )
    @Nullable
    @ODataField( odataName = "InspectionSpecification" )
    private String inspectionSpecification;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecification</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSPECTION_SPECIFICATION =
        new InspectionSpecificationField<String>("InspectionSpecification");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationVersion</b>
     * </p>
     *
     * @return Version Number of Master Inspection Characteristic
     */
    @Key
    @SerializedName( "InspectionSpecificationVersion" )
    @JsonProperty( "InspectionSpecificationVersion" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationVersion" )
    private String inspectionSpecificationVersion;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationVersion</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSPECTION_SPECIFICATION_VERSION =
        new InspectionSpecificationField<String>("InspectionSpecificationVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationPlant</b>
     * </p>
     *
     * @return Plant for Master Inspection Characteristic
     */
    @Key
    @SerializedName( "InspectionSpecificationPlant" )
    @JsonProperty( "InspectionSpecificationPlant" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationPlant" )
    private String inspectionSpecificationPlant;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationPlant</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSPECTION_SPECIFICATION_PLANT =
        new InspectionSpecificationField<String>("InspectionSpecificationPlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> PLANT = new InspectionSpecificationField<String>("Plant");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<LocalDateTime> VALIDITY_START_DATE =
        new InspectionSpecificationField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationSrchTxt</b>
     * </p>
     *
     * @return Search Field
     */
    @SerializedName( "InspectionSpecificationSrchTxt" )
    @JsonProperty( "InspectionSpecificationSrchTxt" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationSrchTxt" )
    private String inspectionSpecificationSrchTxt;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationSrchTxt</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSPECTION_SPECIFICATION_SRCH_TXT =
        new InspectionSpecificationField<String>("InspectionSpecificationSrchTxt");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecGlobalName</b>
     * </p>
     *
     * @return Characteristic Description for Quality Data Exchange
     */
    @SerializedName( "InspSpecGlobalName" )
    @JsonProperty( "InspSpecGlobalName" )
    @Nullable
    @ODataField( odataName = "InspSpecGlobalName" )
    private String inspSpecGlobalName;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecGlobalName</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_GLOBAL_NAME =
        new InspectionSpecificationField<String>("InspSpecGlobalName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationStatus</b>
     * </p>
     *
     * @return Status of Master Record
     */
    @SerializedName( "InspectionSpecificationStatus" )
    @JsonProperty( "InspectionSpecificationStatus" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationStatus" )
    private String inspectionSpecificationStatus;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationStatus</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSPECTION_SPECIFICATION_STATUS =
        new InspectionSpecificationField<String>("InspectionSpecificationStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecTransferType</b>
     * </p>
     *
     * @return Copy Model/Reference Characteristic
     */
    @SerializedName( "InspSpecTransferType" )
    @JsonProperty( "InspSpecTransferType" )
    @Nullable
    @ODataField( odataName = "InspSpecTransferType" )
    private String inspSpecTransferType;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecTransferType</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_TRANSFER_TYPE =
        new InspectionSpecificationField<String>("InspSpecTransferType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecCreatedByUser</b>
     * </p>
     *
     * @return Name of User Who Created the Data Record
     */
    @SerializedName( "InspSpecCreatedByUser" )
    @JsonProperty( "InspSpecCreatedByUser" )
    @Nullable
    @ODataField( odataName = "InspSpecCreatedByUser" )
    private String inspSpecCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecCreatedByUser</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_CREATED_BY_USER =
        new InspectionSpecificationField<String>("InspSpecCreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecCreationDate</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Created
     */
    @SerializedName( "InspSpecCreationDate" )
    @JsonProperty( "InspSpecCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspSpecCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspSpecCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecCreationDate</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<LocalDateTime> INSP_SPEC_CREATION_DATE =
        new InspectionSpecificationField<LocalDateTime>("InspSpecCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecChangedByUser</b>
     * </p>
     *
     * @return Name of User Who Last Changed Data Record
     */
    @SerializedName( "InspSpecChangedByUser" )
    @JsonProperty( "InspSpecChangedByUser" )
    @Nullable
    @ODataField( odataName = "InspSpecChangedByUser" )
    private String inspSpecChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecChangedByUser</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_CHANGED_BY_USER =
        new InspectionSpecificationField<String>("InspSpecChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecChangeDate</b>
     * </p>
     *
     * @return System Date on Which Data Record Was Changed
     */
    @SerializedName( "InspSpecChangeDate" )
    @JsonProperty( "InspSpecChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspSpecChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspSpecChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecChangeDate</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<LocalDateTime> INSP_SPEC_CHANGE_DATE =
        new InspectionSpecificationField<LocalDateTime>("InspSpecChangeDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsQuantitative</b>
     * </p>
     *
     * @return Is Quantitative Characteristic
     */
    @SerializedName( "InspSpecIsQuantitative" )
    @JsonProperty( "InspSpecIsQuantitative" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InspSpecIsQuantitative" )
    private Boolean inspSpecIsQuantitative;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsQuantitative</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<Boolean> INSP_SPEC_IS_QUANTITATIVE =
        new InspectionSpecificationField<Boolean>("InspSpecIsQuantitative");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecCharacteristicType</b>
     * </p>
     *
     * @return Characteristic Type
     */
    @SerializedName( "InspSpecCharacteristicType" )
    @JsonProperty( "InspSpecCharacteristicType" )
    @Nullable
    @ODataField( odataName = "InspSpecCharacteristicType" )
    private String inspSpecCharacteristicType;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecCharacteristicType</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_CHARACTERISTIC_TYPE =
        new InspectionSpecificationField<String>("InspSpecCharacteristicType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsMeasuredValueRqd</b>
     * </p>
     *
     * @return Measured Values Must Be Recorded
     */
    @SerializedName( "InspSpecIsMeasuredValueRqd" )
    @JsonProperty( "InspSpecIsMeasuredValueRqd" )
    @Nullable
    @ODataField( odataName = "InspSpecIsMeasuredValueRqd" )
    private String inspSpecIsMeasuredValueRqd;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsMeasuredValueRqd</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_IS_MEASURED_VALUE_RQD =
        new InspectionSpecificationField<String>("InspSpecIsMeasuredValueRqd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsSelectedSetRequired</b>
     * </p>
     *
     * @return Reference to Characteristic Attribute Required
     */
    @SerializedName( "InspSpecIsSelectedSetRequired" )
    @JsonProperty( "InspSpecIsSelectedSetRequired" )
    @Nullable
    @ODataField( odataName = "InspSpecIsSelectedSetRequired" )
    private String inspSpecIsSelectedSetRequired;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsSelectedSetRequired</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_IS_SELECTED_SET_REQUIRED =
        new InspectionSpecificationField<String>("InspSpecIsSelectedSetRequired");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsUpperLimitRequired</b>
     * </p>
     *
     * @return Upper Specification Limit
     */
    @SerializedName( "InspSpecIsUpperLimitRequired" )
    @JsonProperty( "InspSpecIsUpperLimitRequired" )
    @Nullable
    @ODataField( odataName = "InspSpecIsUpperLimitRequired" )
    private String inspSpecIsUpperLimitRequired;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsUpperLimitRequired</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_IS_UPPER_LIMIT_REQUIRED =
        new InspectionSpecificationField<String>("InspSpecIsUpperLimitRequired");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsLowerLimitRequired</b>
     * </p>
     *
     * @return Lower Specification Limit
     */
    @SerializedName( "InspSpecIsLowerLimitRequired" )
    @JsonProperty( "InspSpecIsLowerLimitRequired" )
    @Nullable
    @ODataField( odataName = "InspSpecIsLowerLimitRequired" )
    private String inspSpecIsLowerLimitRequired;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsLowerLimitRequired</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_IS_LOWER_LIMIT_REQUIRED =
        new InspectionSpecificationField<String>("InspSpecIsLowerLimitRequired");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsTargetValueInLimit</b>
     * </p>
     *
     * @return Check Target Value
     */
    @SerializedName( "InspSpecIsTargetValueInLimit" )
    @JsonProperty( "InspSpecIsTargetValueInLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecIsTargetValueInLimit" )
    private String inspSpecIsTargetValueInLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsTargetValueInLimit</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_IS_TARGET_VALUE_IN_LIMIT =
        new InspectionSpecificationField<String>("InspSpecIsTargetValueInLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionScope</b>
     * </p>
     *
     * @return Inspection Scope
     */
    @SerializedName( "InspectionScope" )
    @JsonProperty( "InspectionScope" )
    @Nullable
    @ODataField( odataName = "InspectionScope" )
    private String inspectionScope;
    /**
     * Use with available fluent helpers to apply the <b>InspectionScope</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSPECTION_SCOPE =
        new InspectionSpecificationField<String>("InspectionScope");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsLongTermInspection</b>
     * </p>
     *
     * @return Long-Term Inspection
     */
    @SerializedName( "InspSpecIsLongTermInspection" )
    @JsonProperty( "InspSpecIsLongTermInspection" )
    @Nullable
    @ODataField( odataName = "InspSpecIsLongTermInspection" )
    private String inspSpecIsLongTermInspection;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsLongTermInspection</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_IS_LONG_TERM_INSPECTION =
        new InspectionSpecificationField<String>("InspSpecIsLongTermInspection");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecRecordingType</b>
     * </p>
     *
     * @return Recording Type
     */
    @SerializedName( "InspSpecRecordingType" )
    @JsonProperty( "InspSpecRecordingType" )
    @Nullable
    @ODataField( odataName = "InspSpecRecordingType" )
    private String inspSpecRecordingType;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecRecordingType</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_RECORDING_TYPE =
        new InspectionSpecificationField<String>("InspSpecRecordingType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspResultIsDocumentationRqd</b>
     * </p>
     *
     * @return Documentation Required for Inspection Result
     */
    @SerializedName( "InspResultIsDocumentationRqd" )
    @JsonProperty( "InspResultIsDocumentationRqd" )
    @Nullable
    @ODataField( odataName = "InspResultIsDocumentationRqd" )
    private String inspResultIsDocumentationRqd;
    /**
     * Use with available fluent helpers to apply the <b>InspResultIsDocumentationRqd</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_RESULT_IS_DOCUMENTATION_RQD =
        new InspectionSpecificationField<String>("InspResultIsDocumentationRqd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecCharcCategory</b>
     * </p>
     *
     * @return Characteristic Category
     */
    @SerializedName( "InspSpecCharcCategory" )
    @JsonProperty( "InspSpecCharcCategory" )
    @Nullable
    @ODataField( odataName = "InspSpecCharcCategory" )
    private String inspSpecCharcCategory;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecCharcCategory</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_CHARC_CATEGORY =
        new InspectionSpecificationField<String>("InspSpecCharcCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsDefectsRecgAutomatic</b>
     * </p>
     *
     * @return Defects Recording Automatically Called Up
     */
    @SerializedName( "InspSpecIsDefectsRecgAutomatic" )
    @JsonProperty( "InspSpecIsDefectsRecgAutomatic" )
    @Nullable
    @ODataField( odataName = "InspSpecIsDefectsRecgAutomatic" )
    private String inspSpecIsDefectsRecgAutomatic;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsDefectsRecgAutomatic</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_IS_DEFECTS_RECG_AUTOMATIC =
        new InspectionSpecificationField<String>("InspSpecIsDefectsRecgAutomatic");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsSampleQtyAdditive</b>
     * </p>
     *
     * @return Inspection Sample Quantity Is Added
     */
    @SerializedName( "InspSpecIsSampleQtyAdditive" )
    @JsonProperty( "InspSpecIsSampleQtyAdditive" )
    @Nullable
    @ODataField( odataName = "InspSpecIsSampleQtyAdditive" )
    private String inspSpecIsSampleQtyAdditive;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsSampleQtyAdditive</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_IS_SAMPLE_QTY_ADDITIVE =
        new InspectionSpecificationField<String>("InspSpecIsSampleQtyAdditive");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsDestructive</b>
     * </p>
     *
     * @return Destructive Inspection
     */
    @SerializedName( "InspSpecIsDestructive" )
    @JsonProperty( "InspSpecIsDestructive" )
    @Nullable
    @ODataField( odataName = "InspSpecIsDestructive" )
    private String inspSpecIsDestructive;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsDestructive</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_IS_DESTRUCTIVE =
        new InspectionSpecificationField<String>("InspSpecIsDestructive");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecResultCalculation</b>
     * </p>
     *
     * @return Characteristic Result Calculation
     */
    @SerializedName( "InspSpecResultCalculation" )
    @JsonProperty( "InspSpecResultCalculation" )
    @Nullable
    @ODataField( odataName = "InspSpecResultCalculation" )
    private String inspSpecResultCalculation;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecResultCalculation</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_RESULT_CALCULATION =
        new InspectionSpecificationField<String>("InspSpecResultCalculation");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsSamplingProcedRqd</b>
     * </p>
     *
     * @return Sampling Procedure Is Required
     */
    @SerializedName( "InspSpecIsSamplingProcedRqd" )
    @JsonProperty( "InspSpecIsSamplingProcedRqd" )
    @Nullable
    @ODataField( odataName = "InspSpecIsSamplingProcedRqd" )
    private String inspSpecIsSamplingProcedRqd;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsSamplingProcedRqd</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_IS_SAMPLING_PROCED_RQD =
        new InspectionSpecificationField<String>("InspSpecIsSamplingProcedRqd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsScrapRelevant</b>
     * </p>
     *
     * @return Characteristic Relevant for Quality Score and Scrap Share
     */
    @SerializedName( "InspSpecIsScrapRelevant" )
    @JsonProperty( "InspSpecIsScrapRelevant" )
    @Nullable
    @ODataField( odataName = "InspSpecIsScrapRelevant" )
    private String inspSpecIsScrapRelevant;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsScrapRelevant</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_IS_SCRAP_RELEVANT =
        new InspectionSpecificationField<String>("InspSpecIsScrapRelevant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsTestEquipmentRqd</b>
     * </p>
     *
     * @return Assignment of Test Equipment Required
     */
    @SerializedName( "InspSpecIsTestEquipmentRqd" )
    @JsonProperty( "InspSpecIsTestEquipmentRqd" )
    @Nullable
    @ODataField( odataName = "InspSpecIsTestEquipmentRqd" )
    private String inspSpecIsTestEquipmentRqd;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsTestEquipmentRqd</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_IS_TEST_EQUIPMENT_RQD =
        new InspectionSpecificationField<String>("InspSpecIsTestEquipmentRqd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsChgDocRequired</b>
     * </p>
     *
     * @return Create Change Documents During Results Recording
     */
    @SerializedName( "InspSpecIsChgDocRequired" )
    @JsonProperty( "InspSpecIsChgDocRequired" )
    @Nullable
    @ODataField( odataName = "InspSpecIsChgDocRequired" )
    private String inspSpecIsChgDocRequired;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsChgDocRequired</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_IS_CHG_DOC_REQUIRED =
        new InspectionSpecificationField<String>("InspSpecIsChgDocRequired");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsControlChartUsed</b>
     * </p>
     *
     * @return SPC Characteristic
     */
    @SerializedName( "InspSpecIsControlChartUsed" )
    @JsonProperty( "InspSpecIsControlChartUsed" )
    @Nullable
    @ODataField( odataName = "InspSpecIsControlChartUsed" )
    private String inspSpecIsControlChartUsed;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecIsControlChartUsed</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_IS_CONTROL_CHART_USED =
        new InspectionSpecificationField<String>("InspSpecIsControlChartUsed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecPrintControl</b>
     * </p>
     *
     * @return Inspection Print Control
     */
    @SerializedName( "InspSpecPrintControl" )
    @JsonProperty( "InspSpecPrintControl" )
    @Nullable
    @ODataField( odataName = "InspSpecPrintControl" )
    private String inspSpecPrintControl;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecPrintControl</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_PRINT_CONTROL =
        new InspectionSpecificationField<String>("InspSpecPrintControl");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecImportanceCode</b>
     * </p>
     *
     * @return Weighting of Characteristic
     */
    @SerializedName( "InspSpecImportanceCode" )
    @JsonProperty( "InspSpecImportanceCode" )
    @Nullable
    @ODataField( odataName = "InspSpecImportanceCode" )
    private String inspSpecImportanceCode;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecImportanceCode</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_IMPORTANCE_CODE =
        new InspectionSpecificationField<String>("InspSpecImportanceCode");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>InspectorQualification</b>
     * </p>
     *
     * @return Inspector Qualification
     */
    @SerializedName( "InspectorQualification" )
    @JsonProperty( "InspectorQualification" )
    @Nullable
    @ODataField( odataName = "InspectorQualification" )
    private String inspectorQualification;
    /**
     * Use with available fluent helpers to apply the <b>InspectorQualification</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSPECTOR_QUALIFICATION =
        new InspectionSpecificationField<String>("InspectorQualification");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField1</b>
     * </p>
     *
     * @return Text Line for Additional Information
     */
    @SerializedName( "InspSpecInformationField1" )
    @JsonProperty( "InspSpecInformationField1" )
    @Nullable
    @ODataField( odataName = "InspSpecInformationField1" )
    private String inspSpecInformationField1;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecInformationField1</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_INFORMATION_FIELD1 =
        new InspectionSpecificationField<String>("InspSpecInformationField1");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField2</b>
     * </p>
     *
     * @return Text Line for Additional Information
     */
    @SerializedName( "InspSpecInformationField2" )
    @JsonProperty( "InspSpecInformationField2" )
    @Nullable
    @ODataField( odataName = "InspSpecInformationField2" )
    private String inspSpecInformationField2;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecInformationField2</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_INFORMATION_FIELD2 =
        new InspectionSpecificationField<String>("InspSpecInformationField2");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField3</b>
     * </p>
     *
     * @return Text Line for Additional Information
     */
    @SerializedName( "InspSpecInformationField3" )
    @JsonProperty( "InspSpecInformationField3" )
    @Nullable
    @ODataField( odataName = "InspSpecInformationField3" )
    private String inspSpecInformationField3;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecInformationField3</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_INFORMATION_FIELD3 =
        new InspectionSpecificationField<String>("InspSpecInformationField3");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>QltyMstrDataAuthorizationGroup</b>
     * </p>
     *
     * @return Authorization Group QM Master Data
     */
    @SerializedName( "QltyMstrDataAuthorizationGroup" )
    @JsonProperty( "QltyMstrDataAuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "QltyMstrDataAuthorizationGroup" )
    private String qltyMstrDataAuthorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>QltyMstrDataAuthorizationGroup</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> QLTY_MSTR_DATA_AUTHORIZATION_GROUP =
        new InspectionSpecificationField<String>("QltyMstrDataAuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspToleranceSpecification</b>
     * </p>
     *
     * @return Tolerance Key
     */
    @SerializedName( "InspToleranceSpecification" )
    @JsonProperty( "InspToleranceSpecification" )
    @Nullable
    @ODataField( odataName = "InspToleranceSpecification" )
    private String inspToleranceSpecification;
    /**
     * Use with available fluent helpers to apply the <b>InspToleranceSpecification</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_TOLERANCE_SPECIFICATION =
        new InspectionSpecificationField<String>("InspToleranceSpecification");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDecimalPlaces</b>
     * </p>
     *
     * @return Number of Places to the Right of a Decimal Point (Accuracy)
     */
    @SerializedName( "InspSpecDecimalPlaces" )
    @JsonProperty( "InspSpecDecimalPlaces" )
    @Nullable
    @ODataField( odataName = "InspSpecDecimalPlaces" )
    private Short inspSpecDecimalPlaces;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecDecimalPlaces</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<Short> INSP_SPEC_DECIMAL_PLACES =
        new InspectionSpecificationField<Short>("InspSpecDecimalPlaces");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationUnit</b>
     * </p>
     *
     * @return Unit of Measurement in Which Quantitative Data Is Stored
     */
    @SerializedName( "InspectionSpecificationUnit" )
    @JsonProperty( "InspectionSpecificationUnit" )
    @Nullable
    @ODataField( odataName = "InspectionSpecificationUnit" )
    private String inspectionSpecificationUnit;
    /**
     * Use with available fluent helpers to apply the <b>InspectionSpecificationUnit</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSPECTION_SPECIFICATION_UNIT =
        new InspectionSpecificationField<String>("InspectionSpecificationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecificationUnitTechName</b>
     * </p>
     *
     * @return External Unit of Measurement for Quantitative Data
     */
    @SerializedName( "InspSpecificationUnitTechName" )
    @JsonProperty( "InspSpecificationUnitTechName" )
    @Nullable
    @ODataField( odataName = "InspSpecificationUnitTechName" )
    private String inspSpecificationUnitTechName;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecificationUnitTechName</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPECIFICATION_UNIT_TECH_NAME =
        new InspectionSpecificationField<String>("InspSpecificationUnitTechName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecificationUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement for Quantitative Data
     */
    @SerializedName( "InspSpecificationUnitISOCode" )
    @JsonProperty( "InspSpecificationUnitISOCode" )
    @Nullable
    @ODataField( odataName = "InspSpecificationUnitISOCode" )
    private String inspSpecificationUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecificationUnitISOCode</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPECIFICATION_UNIT_ISO_CODE =
        new InspectionSpecificationField<String>("InspSpecificationUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecificationUnitSAPCode</b>
     * </p>
     *
     * @return SAP Code for Unit of Measurement for Quantitative Data
     */
    @SerializedName( "InspSpecificationUnitSAPCode" )
    @JsonProperty( "InspSpecificationUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "InspSpecificationUnitSAPCode" )
    private String inspSpecificationUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecificationUnitSAPCode</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPECIFICATION_UNIT_SAP_CODE =
        new InspectionSpecificationField<String>("InspSpecificationUnitSAPCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecTargetValue</b>
     * </p>
     *
     * @return Target Value for a Quantitative Characteristic
     */
    @SerializedName( "InspSpecTargetValue" )
    @JsonProperty( "InspSpecTargetValue" )
    @Nullable
    @ODataField( odataName = "InspSpecTargetValue" )
    private Double inspSpecTargetValue;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecTargetValue</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<Double> INSP_SPEC_TARGET_VALUE =
        new InspectionSpecificationField<Double>("InspSpecTargetValue");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasTargetValue</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasTargetValue" )
    @JsonProperty( "InspSpecHasTargetValue" )
    @Nullable
    @ODataField( odataName = "InspSpecHasTargetValue" )
    private String inspSpecHasTargetValue;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasTargetValue</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_HAS_TARGET_VALUE =
        new InspectionSpecificationField<String>("InspSpecHasTargetValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecLowerLimit</b>
     * </p>
     *
     * @return Lower Specification Limit
     */
    @SerializedName( "InspSpecLowerLimit" )
    @JsonProperty( "InspSpecLowerLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecLowerLimit" )
    private Double inspSpecLowerLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecLowerLimit</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<Double> INSP_SPEC_LOWER_LIMIT =
        new InspectionSpecificationField<Double>("InspSpecLowerLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasLowerLimit</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasLowerLimit" )
    @JsonProperty( "InspSpecHasLowerLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecHasLowerLimit" )
    private String inspSpecHasLowerLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasLowerLimit</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_HAS_LOWER_LIMIT =
        new InspectionSpecificationField<String>("InspSpecHasLowerLimit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecLowerPlausibilityLimit</b>
     * </p>
     *
     * @return Lower Plausibility Limit
     */
    @SerializedName( "InspSpecLowerPlausibilityLimit" )
    @JsonProperty( "InspSpecLowerPlausibilityLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecLowerPlausibilityLimit" )
    private Double inspSpecLowerPlausibilityLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecLowerPlausibilityLimit</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<Double> INSP_SPEC_LOWER_PLAUSIBILITY_LIMIT =
        new InspectionSpecificationField<Double>("InspSpecLowerPlausibilityLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasLowrPlausibilityLmt</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasLowrPlausibilityLmt" )
    @JsonProperty( "InspSpecHasLowrPlausibilityLmt" )
    @Nullable
    @ODataField( odataName = "InspSpecHasLowrPlausibilityLmt" )
    private String inspSpecHasLowrPlausibilityLmt;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasLowrPlausibilityLmt</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_HAS_LOWR_PLAUSIBILITY_LMT =
        new InspectionSpecificationField<String>("InspSpecHasLowrPlausibilityLmt");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFirstLowerSpecLimit</b>
     * </p>
     *
     * @return First Lower Specification Limit
     */
    @SerializedName( "InspSpecFirstLowerSpecLimit" )
    @JsonProperty( "InspSpecFirstLowerSpecLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecFirstLowerSpecLimit" )
    private Double inspSpecFirstLowerSpecLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecFirstLowerSpecLimit</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<Double> INSP_SPEC_FIRST_LOWER_SPEC_LIMIT =
        new InspectionSpecificationField<Double>("InspSpecFirstLowerSpecLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasFirstLowerSpecLimit</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasFirstLowerSpecLimit" )
    @JsonProperty( "InspSpecHasFirstLowerSpecLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecHasFirstLowerSpecLimit" )
    private String inspSpecHasFirstLowerSpecLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasFirstLowerSpecLimit</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_HAS_FIRST_LOWER_SPEC_LIMIT =
        new InspectionSpecificationField<String>("InspSpecHasFirstLowerSpecLimit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecSecondLowerSpecLimit</b>
     * </p>
     *
     * @return Second Lower Specification Limit
     */
    @SerializedName( "InspSpecSecondLowerSpecLimit" )
    @JsonProperty( "InspSpecSecondLowerSpecLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecSecondLowerSpecLimit" )
    private Double inspSpecSecondLowerSpecLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecSecondLowerSpecLimit</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<Double> INSP_SPEC_SECOND_LOWER_SPEC_LIMIT =
        new InspectionSpecificationField<Double>("InspSpecSecondLowerSpecLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasSecondLowrSpecLimit</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasSecondLowrSpecLimit" )
    @JsonProperty( "InspSpecHasSecondLowrSpecLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecHasSecondLowrSpecLimit" )
    private String inspSpecHasSecondLowrSpecLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasSecondLowrSpecLimit</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_HAS_SECOND_LOWR_SPEC_LIMIT =
        new InspectionSpecificationField<String>("InspSpecHasSecondLowrSpecLimit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecLowerSpecLimitChange</b>
     * </p>
     *
     * @return Change to Lower Specification Limit
     */
    @SerializedName( "InspSpecLowerSpecLimitChange" )
    @JsonProperty( "InspSpecLowerSpecLimitChange" )
    @Nullable
    @ODataField( odataName = "InspSpecLowerSpecLimitChange" )
    private Double inspSpecLowerSpecLimitChange;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecLowerSpecLimitChange</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<Double> INSP_SPEC_LOWER_SPEC_LIMIT_CHANGE =
        new InspectionSpecificationField<Double>("InspSpecLowerSpecLimitChange");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasLowrSpecLimitChange</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasLowrSpecLimitChange" )
    @JsonProperty( "InspSpecHasLowrSpecLimitChange" )
    @Nullable
    @ODataField( odataName = "InspSpecHasLowrSpecLimitChange" )
    private String inspSpecHasLowrSpecLimitChange;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasLowrSpecLimitChange</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_HAS_LOWR_SPEC_LIMIT_CHANGE =
        new InspectionSpecificationField<String>("InspSpecHasLowrSpecLimitChange");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecUpperLimit</b>
     * </p>
     *
     * @return Upper Specification Limit
     */
    @SerializedName( "InspSpecUpperLimit" )
    @JsonProperty( "InspSpecUpperLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecUpperLimit" )
    private Double inspSpecUpperLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecUpperLimit</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<Double> INSP_SPEC_UPPER_LIMIT =
        new InspectionSpecificationField<Double>("InspSpecUpperLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasUpperLimit</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasUpperLimit" )
    @JsonProperty( "InspSpecHasUpperLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecHasUpperLimit" )
    private String inspSpecHasUpperLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasUpperLimit</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_HAS_UPPER_LIMIT =
        new InspectionSpecificationField<String>("InspSpecHasUpperLimit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecUpperPlausibilityLimit</b>
     * </p>
     *
     * @return Upper Plausibility Limit
     */
    @SerializedName( "InspSpecUpperPlausibilityLimit" )
    @JsonProperty( "InspSpecUpperPlausibilityLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecUpperPlausibilityLimit" )
    private Double inspSpecUpperPlausibilityLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecUpperPlausibilityLimit</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<Double> INSP_SPEC_UPPER_PLAUSIBILITY_LIMIT =
        new InspectionSpecificationField<Double>("InspSpecUpperPlausibilityLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasUprPlausibilityLmt</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasUprPlausibilityLmt" )
    @JsonProperty( "InspSpecHasUprPlausibilityLmt" )
    @Nullable
    @ODataField( odataName = "InspSpecHasUprPlausibilityLmt" )
    private String inspSpecHasUprPlausibilityLmt;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasUprPlausibilityLmt</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_HAS_UPR_PLAUSIBILITY_LMT =
        new InspectionSpecificationField<String>("InspSpecHasUprPlausibilityLmt");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFirstUpperSpecLimit</b>
     * </p>
     *
     * @return First Upper Specification Limit
     */
    @SerializedName( "InspSpecFirstUpperSpecLimit" )
    @JsonProperty( "InspSpecFirstUpperSpecLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecFirstUpperSpecLimit" )
    private Double inspSpecFirstUpperSpecLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecFirstUpperSpecLimit</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<Double> INSP_SPEC_FIRST_UPPER_SPEC_LIMIT =
        new InspectionSpecificationField<Double>("InspSpecFirstUpperSpecLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasFirstUpperSpecLimit</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasFirstUpperSpecLimit" )
    @JsonProperty( "InspSpecHasFirstUpperSpecLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecHasFirstUpperSpecLimit" )
    private String inspSpecHasFirstUpperSpecLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasFirstUpperSpecLimit</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_HAS_FIRST_UPPER_SPEC_LIMIT =
        new InspectionSpecificationField<String>("InspSpecHasFirstUpperSpecLimit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecSecondUpperSpecLimit</b>
     * </p>
     *
     * @return Second Upper Specification Limit
     */
    @SerializedName( "InspSpecSecondUpperSpecLimit" )
    @JsonProperty( "InspSpecSecondUpperSpecLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecSecondUpperSpecLimit" )
    private Double inspSpecSecondUpperSpecLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecSecondUpperSpecLimit</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<Double> INSP_SPEC_SECOND_UPPER_SPEC_LIMIT =
        new InspectionSpecificationField<Double>("InspSpecSecondUpperSpecLimit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasSecondUprSpecLimit</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasSecondUprSpecLimit" )
    @JsonProperty( "InspSpecHasSecondUprSpecLimit" )
    @Nullable
    @ODataField( odataName = "InspSpecHasSecondUprSpecLimit" )
    private String inspSpecHasSecondUprSpecLimit;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasSecondUprSpecLimit</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_HAS_SECOND_UPR_SPEC_LIMIT =
        new InspectionSpecificationField<String>("InspSpecHasSecondUprSpecLimit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecUpperSpecLimitChange</b>
     * </p>
     *
     * @return Change to Upper Specification Limit
     */
    @SerializedName( "InspSpecUpperSpecLimitChange" )
    @JsonProperty( "InspSpecUpperSpecLimitChange" )
    @Nullable
    @ODataField( odataName = "InspSpecUpperSpecLimitChange" )
    private Double inspSpecUpperSpecLimitChange;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecUpperSpecLimitChange</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<Double> INSP_SPEC_UPPER_SPEC_LIMIT_CHANGE =
        new InspectionSpecificationField<Double>("InspSpecUpperSpecLimitChange");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasUprSpecLimitChange</b>
     * </p>
     *
     * @return Value Not Initial If Set
     */
    @SerializedName( "InspSpecHasUprSpecLimitChange" )
    @JsonProperty( "InspSpecHasUprSpecLimitChange" )
    @Nullable
    @ODataField( odataName = "InspSpecHasUprSpecLimitChange" )
    private String inspSpecHasUprSpecLimitChange;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecHasUprSpecLimitChange</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_HAS_UPR_SPEC_LIMIT_CHANGE =
        new InspectionSpecificationField<String>("InspSpecHasUprSpecLimitChange");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecToleranceChgValidFrom</b>
     * </p>
     *
     * @return Date from Which the Tolerance Change Is Valid
     */
    @SerializedName( "InspSpecToleranceChgValidFrom" )
    @JsonProperty( "InspSpecToleranceChgValidFrom" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspSpecToleranceChgValidFrom",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspSpecToleranceChgValidFrom;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecToleranceChgValidFrom</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<LocalDateTime> INSP_SPEC_TOLERANCE_CHG_VALID_FROM =
        new InspectionSpecificationField<LocalDateTime>("InspSpecToleranceChgValidFrom");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecToleranceChgValidTo</b>
     * </p>
     *
     * @return Date Until Which the Tolerance Change Is Valid
     */
    @SerializedName( "InspSpecToleranceChgValidTo" )
    @JsonProperty( "InspSpecToleranceChgValidTo" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InspSpecToleranceChgValidTo",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime inspSpecToleranceChgValidTo;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecToleranceChgValidTo</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<LocalDateTime> INSP_SPEC_TOLERANCE_CHG_VALID_TO =
        new InspectionSpecificationField<LocalDateTime>("InspSpecToleranceChgValidTo");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeGrpRejection</b>
     * </p>
     *
     * @return Defect Code Group for General Rejection
     */
    @SerializedName( "InspSpecDefectCodeGrpRejection" )
    @JsonProperty( "InspSpecDefectCodeGrpRejection" )
    @Nullable
    @ODataField( odataName = "InspSpecDefectCodeGrpRejection" )
    private String inspSpecDefectCodeGrpRejection;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecDefectCodeGrpRejection</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_DEFECT_CODE_GRP_REJECTION =
        new InspectionSpecificationField<String>("InspSpecDefectCodeGrpRejection");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeRejection</b>
     * </p>
     *
     * @return Defect Code for Rejection: General
     */
    @SerializedName( "InspSpecDefectCodeRejection" )
    @JsonProperty( "InspSpecDefectCodeRejection" )
    @Nullable
    @ODataField( odataName = "InspSpecDefectCodeRejection" )
    private String inspSpecDefectCodeRejection;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecDefectCodeRejection</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_DEFECT_CODE_REJECTION =
        new InspectionSpecificationField<String>("InspSpecDefectCodeRejection");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeGrpRjcnUpper</b>
     * </p>
     *
     * @return Defect Code Group for Rejection at Upper Tolerance
     */
    @SerializedName( "InspSpecDefectCodeGrpRjcnUpper" )
    @JsonProperty( "InspSpecDefectCodeGrpRjcnUpper" )
    @Nullable
    @ODataField( odataName = "InspSpecDefectCodeGrpRjcnUpper" )
    private String inspSpecDefectCodeGrpRjcnUpper;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecDefectCodeGrpRjcnUpper</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_DEFECT_CODE_GRP_RJCN_UPPER =
        new InspectionSpecificationField<String>("InspSpecDefectCodeGrpRjcnUpper");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeRjcnUpper</b>
     * </p>
     *
     * @return Defect Code for Rejection at Upper Specification Limit
     */
    @SerializedName( "InspSpecDefectCodeRjcnUpper" )
    @JsonProperty( "InspSpecDefectCodeRjcnUpper" )
    @Nullable
    @ODataField( odataName = "InspSpecDefectCodeRjcnUpper" )
    private String inspSpecDefectCodeRjcnUpper;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecDefectCodeRjcnUpper</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_DEFECT_CODE_RJCN_UPPER =
        new InspectionSpecificationField<String>("InspSpecDefectCodeRjcnUpper");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeGrpRjcnLower</b>
     * </p>
     *
     * @return Defect Code Group for Rejection at Lower Tolerance
     */
    @SerializedName( "InspSpecDefectCodeGrpRjcnLower" )
    @JsonProperty( "InspSpecDefectCodeGrpRjcnLower" )
    @Nullable
    @ODataField( odataName = "InspSpecDefectCodeGrpRjcnLower" )
    private String inspSpecDefectCodeGrpRjcnLower;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecDefectCodeGrpRjcnLower</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_DEFECT_CODE_GRP_RJCN_LOWER =
        new InspectionSpecificationField<String>("InspSpecDefectCodeGrpRjcnLower");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeRjcnLower</b>
     * </p>
     *
     * @return Defect Code for Rejection at Lower Specification Limit
     */
    @SerializedName( "InspSpecDefectCodeRjcnLower" )
    @JsonProperty( "InspSpecDefectCodeRjcnLower" )
    @Nullable
    @ODataField( odataName = "InspSpecDefectCodeRjcnLower" )
    private String inspSpecDefectCodeRjcnLower;
    /**
     * Use with available fluent helpers to apply the <b>InspSpecDefectCodeRjcnLower</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> INSP_SPEC_DEFECT_CODE_RJCN_LOWER =
        new InspectionSpecificationField<String>("InspSpecDefectCodeRjcnLower");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicInternalID</b>
     * </p>
     *
     * @return Internal characteristic
     */
    @SerializedName( "CharacteristicInternalID" )
    @JsonProperty( "CharacteristicInternalID" )
    @Nullable
    @ODataField( odataName = "CharacteristicInternalID" )
    private String characteristicInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicInternalID</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> CHARACTERISTIC_INTERNAL_ID =
        new InspectionSpecificationField<String>("CharacteristicInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DefectFractionEstimationProced</b>
     * </p>
     *
     * @return Fraction Calculation
     */
    @SerializedName( "DefectFractionEstimationProced" )
    @JsonProperty( "DefectFractionEstimationProced" )
    @Nullable
    @ODataField( odataName = "DefectFractionEstimationProced" )
    private String defectFractionEstimationProced;
    /**
     * Use with available fluent helpers to apply the <b>DefectFractionEstimationProced</b> field to query operations.
     *
     */
    public final static InspectionSpecificationField<String> DEFECT_FRACTION_ESTIMATION_PROCED =
        new InspectionSpecificationField<String>("DefectFractionEstimationProced");
    /**
     * Navigation property <b>to_Text</b> for <b>InspectionSpecification</b> to multiple
     * <b>InspectionSpecificationText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<InspectionSpecificationText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static InspectionSpecificationLink<InspectionSpecificationText> TO_TEXT =
        new InspectionSpecificationLink<InspectionSpecificationText>("to_Text");

    @Nonnull
    @Override
    public Class<InspectionSpecification> getType()
    {
        return InspectionSpecification.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecification</b>
     * </p>
     *
     * @param inspectionSpecification
     *            Master Inspection Characteristic
     */
    public void setInspectionSpecification( @Nullable final String inspectionSpecification )
    {
        rememberChangedField("InspectionSpecification", this.inspectionSpecification);
        this.inspectionSpecification = inspectionSpecification;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationVersion</b>
     * </p>
     *
     * @param inspectionSpecificationVersion
     *            Version Number of Master Inspection Characteristic
     */
    public void setInspectionSpecificationVersion( @Nullable final String inspectionSpecificationVersion )
    {
        rememberChangedField("InspectionSpecificationVersion", this.inspectionSpecificationVersion);
        this.inspectionSpecificationVersion = inspectionSpecificationVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationPlant</b>
     * </p>
     *
     * @param inspectionSpecificationPlant
     *            Plant for Master Inspection Characteristic
     */
    public void setInspectionSpecificationPlant( @Nullable final String inspectionSpecificationPlant )
    {
        rememberChangedField("InspectionSpecificationPlant", this.inspectionSpecificationPlant);
        this.inspectionSpecificationPlant = inspectionSpecificationPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationSrchTxt</b>
     * </p>
     *
     * @param inspectionSpecificationSrchTxt
     *            Search Field
     */
    public void setInspectionSpecificationSrchTxt( @Nullable final String inspectionSpecificationSrchTxt )
    {
        rememberChangedField("InspectionSpecificationSrchTxt", this.inspectionSpecificationSrchTxt);
        this.inspectionSpecificationSrchTxt = inspectionSpecificationSrchTxt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecGlobalName</b>
     * </p>
     *
     * @param inspSpecGlobalName
     *            Characteristic Description for Quality Data Exchange
     */
    public void setInspSpecGlobalName( @Nullable final String inspSpecGlobalName )
    {
        rememberChangedField("InspSpecGlobalName", this.inspSpecGlobalName);
        this.inspSpecGlobalName = inspSpecGlobalName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationStatus</b>
     * </p>
     *
     * @param inspectionSpecificationStatus
     *            Status of Master Record
     */
    public void setInspectionSpecificationStatus( @Nullable final String inspectionSpecificationStatus )
    {
        rememberChangedField("InspectionSpecificationStatus", this.inspectionSpecificationStatus);
        this.inspectionSpecificationStatus = inspectionSpecificationStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecTransferType</b>
     * </p>
     *
     * @param inspSpecTransferType
     *            Copy Model/Reference Characteristic
     */
    public void setInspSpecTransferType( @Nullable final String inspSpecTransferType )
    {
        rememberChangedField("InspSpecTransferType", this.inspSpecTransferType);
        this.inspSpecTransferType = inspSpecTransferType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecCreatedByUser</b>
     * </p>
     *
     * @param inspSpecCreatedByUser
     *            Name of User Who Created the Data Record
     */
    public void setInspSpecCreatedByUser( @Nullable final String inspSpecCreatedByUser )
    {
        rememberChangedField("InspSpecCreatedByUser", this.inspSpecCreatedByUser);
        this.inspSpecCreatedByUser = inspSpecCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecCreationDate</b>
     * </p>
     *
     * @param inspSpecCreationDate
     *            System Date on Which Data Record Was Created
     */
    public void setInspSpecCreationDate( @Nullable final LocalDateTime inspSpecCreationDate )
    {
        rememberChangedField("InspSpecCreationDate", this.inspSpecCreationDate);
        this.inspSpecCreationDate = inspSpecCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecChangedByUser</b>
     * </p>
     *
     * @param inspSpecChangedByUser
     *            Name of User Who Last Changed Data Record
     */
    public void setInspSpecChangedByUser( @Nullable final String inspSpecChangedByUser )
    {
        rememberChangedField("InspSpecChangedByUser", this.inspSpecChangedByUser);
        this.inspSpecChangedByUser = inspSpecChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecChangeDate</b>
     * </p>
     *
     * @param inspSpecChangeDate
     *            System Date on Which Data Record Was Changed
     */
    public void setInspSpecChangeDate( @Nullable final LocalDateTime inspSpecChangeDate )
    {
        rememberChangedField("InspSpecChangeDate", this.inspSpecChangeDate);
        this.inspSpecChangeDate = inspSpecChangeDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsQuantitative</b>
     * </p>
     *
     * @param inspSpecIsQuantitative
     *            Is Quantitative Characteristic
     */
    public void setInspSpecIsQuantitative( @Nullable final Boolean inspSpecIsQuantitative )
    {
        rememberChangedField("InspSpecIsQuantitative", this.inspSpecIsQuantitative);
        this.inspSpecIsQuantitative = inspSpecIsQuantitative;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecCharacteristicType</b>
     * </p>
     *
     * @param inspSpecCharacteristicType
     *            Characteristic Type
     */
    public void setInspSpecCharacteristicType( @Nullable final String inspSpecCharacteristicType )
    {
        rememberChangedField("InspSpecCharacteristicType", this.inspSpecCharacteristicType);
        this.inspSpecCharacteristicType = inspSpecCharacteristicType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsMeasuredValueRqd</b>
     * </p>
     *
     * @param inspSpecIsMeasuredValueRqd
     *            Measured Values Must Be Recorded
     */
    public void setInspSpecIsMeasuredValueRqd( @Nullable final String inspSpecIsMeasuredValueRqd )
    {
        rememberChangedField("InspSpecIsMeasuredValueRqd", this.inspSpecIsMeasuredValueRqd);
        this.inspSpecIsMeasuredValueRqd = inspSpecIsMeasuredValueRqd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsSelectedSetRequired</b>
     * </p>
     *
     * @param inspSpecIsSelectedSetRequired
     *            Reference to Characteristic Attribute Required
     */
    public void setInspSpecIsSelectedSetRequired( @Nullable final String inspSpecIsSelectedSetRequired )
    {
        rememberChangedField("InspSpecIsSelectedSetRequired", this.inspSpecIsSelectedSetRequired);
        this.inspSpecIsSelectedSetRequired = inspSpecIsSelectedSetRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsUpperLimitRequired</b>
     * </p>
     *
     * @param inspSpecIsUpperLimitRequired
     *            Upper Specification Limit
     */
    public void setInspSpecIsUpperLimitRequired( @Nullable final String inspSpecIsUpperLimitRequired )
    {
        rememberChangedField("InspSpecIsUpperLimitRequired", this.inspSpecIsUpperLimitRequired);
        this.inspSpecIsUpperLimitRequired = inspSpecIsUpperLimitRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsLowerLimitRequired</b>
     * </p>
     *
     * @param inspSpecIsLowerLimitRequired
     *            Lower Specification Limit
     */
    public void setInspSpecIsLowerLimitRequired( @Nullable final String inspSpecIsLowerLimitRequired )
    {
        rememberChangedField("InspSpecIsLowerLimitRequired", this.inspSpecIsLowerLimitRequired);
        this.inspSpecIsLowerLimitRequired = inspSpecIsLowerLimitRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsTargetValueInLimit</b>
     * </p>
     *
     * @param inspSpecIsTargetValueInLimit
     *            Check Target Value
     */
    public void setInspSpecIsTargetValueInLimit( @Nullable final String inspSpecIsTargetValueInLimit )
    {
        rememberChangedField("InspSpecIsTargetValueInLimit", this.inspSpecIsTargetValueInLimit);
        this.inspSpecIsTargetValueInLimit = inspSpecIsTargetValueInLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspectionScope</b>
     * </p>
     *
     * @param inspectionScope
     *            Inspection Scope
     */
    public void setInspectionScope( @Nullable final String inspectionScope )
    {
        rememberChangedField("InspectionScope", this.inspectionScope);
        this.inspectionScope = inspectionScope;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsLongTermInspection</b>
     * </p>
     *
     * @param inspSpecIsLongTermInspection
     *            Long-Term Inspection
     */
    public void setInspSpecIsLongTermInspection( @Nullable final String inspSpecIsLongTermInspection )
    {
        rememberChangedField("InspSpecIsLongTermInspection", this.inspSpecIsLongTermInspection);
        this.inspSpecIsLongTermInspection = inspSpecIsLongTermInspection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecRecordingType</b>
     * </p>
     *
     * @param inspSpecRecordingType
     *            Recording Type
     */
    public void setInspSpecRecordingType( @Nullable final String inspSpecRecordingType )
    {
        rememberChangedField("InspSpecRecordingType", this.inspSpecRecordingType);
        this.inspSpecRecordingType = inspSpecRecordingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspResultIsDocumentationRqd</b>
     * </p>
     *
     * @param inspResultIsDocumentationRqd
     *            Documentation Required for Inspection Result
     */
    public void setInspResultIsDocumentationRqd( @Nullable final String inspResultIsDocumentationRqd )
    {
        rememberChangedField("InspResultIsDocumentationRqd", this.inspResultIsDocumentationRqd);
        this.inspResultIsDocumentationRqd = inspResultIsDocumentationRqd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecCharcCategory</b>
     * </p>
     *
     * @param inspSpecCharcCategory
     *            Characteristic Category
     */
    public void setInspSpecCharcCategory( @Nullable final String inspSpecCharcCategory )
    {
        rememberChangedField("InspSpecCharcCategory", this.inspSpecCharcCategory);
        this.inspSpecCharcCategory = inspSpecCharcCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsDefectsRecgAutomatic</b>
     * </p>
     *
     * @param inspSpecIsDefectsRecgAutomatic
     *            Defects Recording Automatically Called Up
     */
    public void setInspSpecIsDefectsRecgAutomatic( @Nullable final String inspSpecIsDefectsRecgAutomatic )
    {
        rememberChangedField("InspSpecIsDefectsRecgAutomatic", this.inspSpecIsDefectsRecgAutomatic);
        this.inspSpecIsDefectsRecgAutomatic = inspSpecIsDefectsRecgAutomatic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsSampleQtyAdditive</b>
     * </p>
     *
     * @param inspSpecIsSampleQtyAdditive
     *            Inspection Sample Quantity Is Added
     */
    public void setInspSpecIsSampleQtyAdditive( @Nullable final String inspSpecIsSampleQtyAdditive )
    {
        rememberChangedField("InspSpecIsSampleQtyAdditive", this.inspSpecIsSampleQtyAdditive);
        this.inspSpecIsSampleQtyAdditive = inspSpecIsSampleQtyAdditive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsDestructive</b>
     * </p>
     *
     * @param inspSpecIsDestructive
     *            Destructive Inspection
     */
    public void setInspSpecIsDestructive( @Nullable final String inspSpecIsDestructive )
    {
        rememberChangedField("InspSpecIsDestructive", this.inspSpecIsDestructive);
        this.inspSpecIsDestructive = inspSpecIsDestructive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecResultCalculation</b>
     * </p>
     *
     * @param inspSpecResultCalculation
     *            Characteristic Result Calculation
     */
    public void setInspSpecResultCalculation( @Nullable final String inspSpecResultCalculation )
    {
        rememberChangedField("InspSpecResultCalculation", this.inspSpecResultCalculation);
        this.inspSpecResultCalculation = inspSpecResultCalculation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsSamplingProcedRqd</b>
     * </p>
     *
     * @param inspSpecIsSamplingProcedRqd
     *            Sampling Procedure Is Required
     */
    public void setInspSpecIsSamplingProcedRqd( @Nullable final String inspSpecIsSamplingProcedRqd )
    {
        rememberChangedField("InspSpecIsSamplingProcedRqd", this.inspSpecIsSamplingProcedRqd);
        this.inspSpecIsSamplingProcedRqd = inspSpecIsSamplingProcedRqd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsScrapRelevant</b>
     * </p>
     *
     * @param inspSpecIsScrapRelevant
     *            Characteristic Relevant for Quality Score and Scrap Share
     */
    public void setInspSpecIsScrapRelevant( @Nullable final String inspSpecIsScrapRelevant )
    {
        rememberChangedField("InspSpecIsScrapRelevant", this.inspSpecIsScrapRelevant);
        this.inspSpecIsScrapRelevant = inspSpecIsScrapRelevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsTestEquipmentRqd</b>
     * </p>
     *
     * @param inspSpecIsTestEquipmentRqd
     *            Assignment of Test Equipment Required
     */
    public void setInspSpecIsTestEquipmentRqd( @Nullable final String inspSpecIsTestEquipmentRqd )
    {
        rememberChangedField("InspSpecIsTestEquipmentRqd", this.inspSpecIsTestEquipmentRqd);
        this.inspSpecIsTestEquipmentRqd = inspSpecIsTestEquipmentRqd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsChgDocRequired</b>
     * </p>
     *
     * @param inspSpecIsChgDocRequired
     *            Create Change Documents During Results Recording
     */
    public void setInspSpecIsChgDocRequired( @Nullable final String inspSpecIsChgDocRequired )
    {
        rememberChangedField("InspSpecIsChgDocRequired", this.inspSpecIsChgDocRequired);
        this.inspSpecIsChgDocRequired = inspSpecIsChgDocRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecIsControlChartUsed</b>
     * </p>
     *
     * @param inspSpecIsControlChartUsed
     *            SPC Characteristic
     */
    public void setInspSpecIsControlChartUsed( @Nullable final String inspSpecIsControlChartUsed )
    {
        rememberChangedField("InspSpecIsControlChartUsed", this.inspSpecIsControlChartUsed);
        this.inspSpecIsControlChartUsed = inspSpecIsControlChartUsed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecPrintControl</b>
     * </p>
     *
     * @param inspSpecPrintControl
     *            Inspection Print Control
     */
    public void setInspSpecPrintControl( @Nullable final String inspSpecPrintControl )
    {
        rememberChangedField("InspSpecPrintControl", this.inspSpecPrintControl);
        this.inspSpecPrintControl = inspSpecPrintControl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecImportanceCode</b>
     * </p>
     *
     * @param inspSpecImportanceCode
     *            Weighting of Characteristic
     */
    public void setInspSpecImportanceCode( @Nullable final String inspSpecImportanceCode )
    {
        rememberChangedField("InspSpecImportanceCode", this.inspSpecImportanceCode);
        this.inspSpecImportanceCode = inspSpecImportanceCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>InspectorQualification</b>
     * </p>
     *
     * @param inspectorQualification
     *            Inspector Qualification
     */
    public void setInspectorQualification( @Nullable final String inspectorQualification )
    {
        rememberChangedField("InspectorQualification", this.inspectorQualification);
        this.inspectorQualification = inspectorQualification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField1</b>
     * </p>
     *
     * @param inspSpecInformationField1
     *            Text Line for Additional Information
     */
    public void setInspSpecInformationField1( @Nullable final String inspSpecInformationField1 )
    {
        rememberChangedField("InspSpecInformationField1", this.inspSpecInformationField1);
        this.inspSpecInformationField1 = inspSpecInformationField1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField2</b>
     * </p>
     *
     * @param inspSpecInformationField2
     *            Text Line for Additional Information
     */
    public void setInspSpecInformationField2( @Nullable final String inspSpecInformationField2 )
    {
        rememberChangedField("InspSpecInformationField2", this.inspSpecInformationField2);
        this.inspSpecInformationField2 = inspSpecInformationField2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecInformationField3</b>
     * </p>
     *
     * @param inspSpecInformationField3
     *            Text Line for Additional Information
     */
    public void setInspSpecInformationField3( @Nullable final String inspSpecInformationField3 )
    {
        rememberChangedField("InspSpecInformationField3", this.inspSpecInformationField3);
        this.inspSpecInformationField3 = inspSpecInformationField3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>QltyMstrDataAuthorizationGroup</b>
     * </p>
     *
     * @param qltyMstrDataAuthorizationGroup
     *            Authorization Group QM Master Data
     */
    public void setQltyMstrDataAuthorizationGroup( @Nullable final String qltyMstrDataAuthorizationGroup )
    {
        rememberChangedField("QltyMstrDataAuthorizationGroup", this.qltyMstrDataAuthorizationGroup);
        this.qltyMstrDataAuthorizationGroup = qltyMstrDataAuthorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspToleranceSpecification</b>
     * </p>
     *
     * @param inspToleranceSpecification
     *            Tolerance Key
     */
    public void setInspToleranceSpecification( @Nullable final String inspToleranceSpecification )
    {
        rememberChangedField("InspToleranceSpecification", this.inspToleranceSpecification);
        this.inspToleranceSpecification = inspToleranceSpecification;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDecimalPlaces</b>
     * </p>
     *
     * @param inspSpecDecimalPlaces
     *            Number of Places to the Right of a Decimal Point (Accuracy)
     */
    public void setInspSpecDecimalPlaces( @Nullable final Short inspSpecDecimalPlaces )
    {
        rememberChangedField("InspSpecDecimalPlaces", this.inspSpecDecimalPlaces);
        this.inspSpecDecimalPlaces = inspSpecDecimalPlaces;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspectionSpecificationUnit</b>
     * </p>
     *
     * @param inspectionSpecificationUnit
     *            Unit of Measurement in Which Quantitative Data Is Stored
     */
    public void setInspectionSpecificationUnit( @Nullable final String inspectionSpecificationUnit )
    {
        rememberChangedField("InspectionSpecificationUnit", this.inspectionSpecificationUnit);
        this.inspectionSpecificationUnit = inspectionSpecificationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecificationUnitTechName</b>
     * </p>
     *
     * @param inspSpecificationUnitTechName
     *            External Unit of Measurement for Quantitative Data
     */
    public void setInspSpecificationUnitTechName( @Nullable final String inspSpecificationUnitTechName )
    {
        rememberChangedField("InspSpecificationUnitTechName", this.inspSpecificationUnitTechName);
        this.inspSpecificationUnitTechName = inspSpecificationUnitTechName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecificationUnitISOCode</b>
     * </p>
     *
     * @param inspSpecificationUnitISOCode
     *            ISO Code for Unit of Measurement for Quantitative Data
     */
    public void setInspSpecificationUnitISOCode( @Nullable final String inspSpecificationUnitISOCode )
    {
        rememberChangedField("InspSpecificationUnitISOCode", this.inspSpecificationUnitISOCode);
        this.inspSpecificationUnitISOCode = inspSpecificationUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecificationUnitSAPCode</b>
     * </p>
     *
     * @param inspSpecificationUnitSAPCode
     *            SAP Code for Unit of Measurement for Quantitative Data
     */
    public void setInspSpecificationUnitSAPCode( @Nullable final String inspSpecificationUnitSAPCode )
    {
        rememberChangedField("InspSpecificationUnitSAPCode", this.inspSpecificationUnitSAPCode);
        this.inspSpecificationUnitSAPCode = inspSpecificationUnitSAPCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecTargetValue</b>
     * </p>
     *
     * @param inspSpecTargetValue
     *            Target Value for a Quantitative Characteristic
     */
    public void setInspSpecTargetValue( @Nullable final Double inspSpecTargetValue )
    {
        rememberChangedField("InspSpecTargetValue", this.inspSpecTargetValue);
        this.inspSpecTargetValue = inspSpecTargetValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasTargetValue</b>
     * </p>
     *
     * @param inspSpecHasTargetValue
     *            Value Not Initial If Set
     */
    public void setInspSpecHasTargetValue( @Nullable final String inspSpecHasTargetValue )
    {
        rememberChangedField("InspSpecHasTargetValue", this.inspSpecHasTargetValue);
        this.inspSpecHasTargetValue = inspSpecHasTargetValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecLowerLimit</b>
     * </p>
     *
     * @param inspSpecLowerLimit
     *            Lower Specification Limit
     */
    public void setInspSpecLowerLimit( @Nullable final Double inspSpecLowerLimit )
    {
        rememberChangedField("InspSpecLowerLimit", this.inspSpecLowerLimit);
        this.inspSpecLowerLimit = inspSpecLowerLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasLowerLimit</b>
     * </p>
     *
     * @param inspSpecHasLowerLimit
     *            Value Not Initial If Set
     */
    public void setInspSpecHasLowerLimit( @Nullable final String inspSpecHasLowerLimit )
    {
        rememberChangedField("InspSpecHasLowerLimit", this.inspSpecHasLowerLimit);
        this.inspSpecHasLowerLimit = inspSpecHasLowerLimit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecLowerPlausibilityLimit</b>
     * </p>
     *
     * @param inspSpecLowerPlausibilityLimit
     *            Lower Plausibility Limit
     */
    public void setInspSpecLowerPlausibilityLimit( @Nullable final Double inspSpecLowerPlausibilityLimit )
    {
        rememberChangedField("InspSpecLowerPlausibilityLimit", this.inspSpecLowerPlausibilityLimit);
        this.inspSpecLowerPlausibilityLimit = inspSpecLowerPlausibilityLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasLowrPlausibilityLmt</b>
     * </p>
     *
     * @param inspSpecHasLowrPlausibilityLmt
     *            Value Not Initial If Set
     */
    public void setInspSpecHasLowrPlausibilityLmt( @Nullable final String inspSpecHasLowrPlausibilityLmt )
    {
        rememberChangedField("InspSpecHasLowrPlausibilityLmt", this.inspSpecHasLowrPlausibilityLmt);
        this.inspSpecHasLowrPlausibilityLmt = inspSpecHasLowrPlausibilityLmt;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFirstLowerSpecLimit</b>
     * </p>
     *
     * @param inspSpecFirstLowerSpecLimit
     *            First Lower Specification Limit
     */
    public void setInspSpecFirstLowerSpecLimit( @Nullable final Double inspSpecFirstLowerSpecLimit )
    {
        rememberChangedField("InspSpecFirstLowerSpecLimit", this.inspSpecFirstLowerSpecLimit);
        this.inspSpecFirstLowerSpecLimit = inspSpecFirstLowerSpecLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasFirstLowerSpecLimit</b>
     * </p>
     *
     * @param inspSpecHasFirstLowerSpecLimit
     *            Value Not Initial If Set
     */
    public void setInspSpecHasFirstLowerSpecLimit( @Nullable final String inspSpecHasFirstLowerSpecLimit )
    {
        rememberChangedField("InspSpecHasFirstLowerSpecLimit", this.inspSpecHasFirstLowerSpecLimit);
        this.inspSpecHasFirstLowerSpecLimit = inspSpecHasFirstLowerSpecLimit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecSecondLowerSpecLimit</b>
     * </p>
     *
     * @param inspSpecSecondLowerSpecLimit
     *            Second Lower Specification Limit
     */
    public void setInspSpecSecondLowerSpecLimit( @Nullable final Double inspSpecSecondLowerSpecLimit )
    {
        rememberChangedField("InspSpecSecondLowerSpecLimit", this.inspSpecSecondLowerSpecLimit);
        this.inspSpecSecondLowerSpecLimit = inspSpecSecondLowerSpecLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasSecondLowrSpecLimit</b>
     * </p>
     *
     * @param inspSpecHasSecondLowrSpecLimit
     *            Value Not Initial If Set
     */
    public void setInspSpecHasSecondLowrSpecLimit( @Nullable final String inspSpecHasSecondLowrSpecLimit )
    {
        rememberChangedField("InspSpecHasSecondLowrSpecLimit", this.inspSpecHasSecondLowrSpecLimit);
        this.inspSpecHasSecondLowrSpecLimit = inspSpecHasSecondLowrSpecLimit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecLowerSpecLimitChange</b>
     * </p>
     *
     * @param inspSpecLowerSpecLimitChange
     *            Change to Lower Specification Limit
     */
    public void setInspSpecLowerSpecLimitChange( @Nullable final Double inspSpecLowerSpecLimitChange )
    {
        rememberChangedField("InspSpecLowerSpecLimitChange", this.inspSpecLowerSpecLimitChange);
        this.inspSpecLowerSpecLimitChange = inspSpecLowerSpecLimitChange;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasLowrSpecLimitChange</b>
     * </p>
     *
     * @param inspSpecHasLowrSpecLimitChange
     *            Value Not Initial If Set
     */
    public void setInspSpecHasLowrSpecLimitChange( @Nullable final String inspSpecHasLowrSpecLimitChange )
    {
        rememberChangedField("InspSpecHasLowrSpecLimitChange", this.inspSpecHasLowrSpecLimitChange);
        this.inspSpecHasLowrSpecLimitChange = inspSpecHasLowrSpecLimitChange;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecUpperLimit</b>
     * </p>
     *
     * @param inspSpecUpperLimit
     *            Upper Specification Limit
     */
    public void setInspSpecUpperLimit( @Nullable final Double inspSpecUpperLimit )
    {
        rememberChangedField("InspSpecUpperLimit", this.inspSpecUpperLimit);
        this.inspSpecUpperLimit = inspSpecUpperLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasUpperLimit</b>
     * </p>
     *
     * @param inspSpecHasUpperLimit
     *            Value Not Initial If Set
     */
    public void setInspSpecHasUpperLimit( @Nullable final String inspSpecHasUpperLimit )
    {
        rememberChangedField("InspSpecHasUpperLimit", this.inspSpecHasUpperLimit);
        this.inspSpecHasUpperLimit = inspSpecHasUpperLimit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecUpperPlausibilityLimit</b>
     * </p>
     *
     * @param inspSpecUpperPlausibilityLimit
     *            Upper Plausibility Limit
     */
    public void setInspSpecUpperPlausibilityLimit( @Nullable final Double inspSpecUpperPlausibilityLimit )
    {
        rememberChangedField("InspSpecUpperPlausibilityLimit", this.inspSpecUpperPlausibilityLimit);
        this.inspSpecUpperPlausibilityLimit = inspSpecUpperPlausibilityLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasUprPlausibilityLmt</b>
     * </p>
     *
     * @param inspSpecHasUprPlausibilityLmt
     *            Value Not Initial If Set
     */
    public void setInspSpecHasUprPlausibilityLmt( @Nullable final String inspSpecHasUprPlausibilityLmt )
    {
        rememberChangedField("InspSpecHasUprPlausibilityLmt", this.inspSpecHasUprPlausibilityLmt);
        this.inspSpecHasUprPlausibilityLmt = inspSpecHasUprPlausibilityLmt;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecFirstUpperSpecLimit</b>
     * </p>
     *
     * @param inspSpecFirstUpperSpecLimit
     *            First Upper Specification Limit
     */
    public void setInspSpecFirstUpperSpecLimit( @Nullable final Double inspSpecFirstUpperSpecLimit )
    {
        rememberChangedField("InspSpecFirstUpperSpecLimit", this.inspSpecFirstUpperSpecLimit);
        this.inspSpecFirstUpperSpecLimit = inspSpecFirstUpperSpecLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasFirstUpperSpecLimit</b>
     * </p>
     *
     * @param inspSpecHasFirstUpperSpecLimit
     *            Value Not Initial If Set
     */
    public void setInspSpecHasFirstUpperSpecLimit( @Nullable final String inspSpecHasFirstUpperSpecLimit )
    {
        rememberChangedField("InspSpecHasFirstUpperSpecLimit", this.inspSpecHasFirstUpperSpecLimit);
        this.inspSpecHasFirstUpperSpecLimit = inspSpecHasFirstUpperSpecLimit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecSecondUpperSpecLimit</b>
     * </p>
     *
     * @param inspSpecSecondUpperSpecLimit
     *            Second Upper Specification Limit
     */
    public void setInspSpecSecondUpperSpecLimit( @Nullable final Double inspSpecSecondUpperSpecLimit )
    {
        rememberChangedField("InspSpecSecondUpperSpecLimit", this.inspSpecSecondUpperSpecLimit);
        this.inspSpecSecondUpperSpecLimit = inspSpecSecondUpperSpecLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasSecondUprSpecLimit</b>
     * </p>
     *
     * @param inspSpecHasSecondUprSpecLimit
     *            Value Not Initial If Set
     */
    public void setInspSpecHasSecondUprSpecLimit( @Nullable final String inspSpecHasSecondUprSpecLimit )
    {
        rememberChangedField("InspSpecHasSecondUprSpecLimit", this.inspSpecHasSecondUprSpecLimit);
        this.inspSpecHasSecondUprSpecLimit = inspSpecHasSecondUprSpecLimit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecUpperSpecLimitChange</b>
     * </p>
     *
     * @param inspSpecUpperSpecLimitChange
     *            Change to Upper Specification Limit
     */
    public void setInspSpecUpperSpecLimitChange( @Nullable final Double inspSpecUpperSpecLimitChange )
    {
        rememberChangedField("InspSpecUpperSpecLimitChange", this.inspSpecUpperSpecLimitChange);
        this.inspSpecUpperSpecLimitChange = inspSpecUpperSpecLimitChange;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecHasUprSpecLimitChange</b>
     * </p>
     *
     * @param inspSpecHasUprSpecLimitChange
     *            Value Not Initial If Set
     */
    public void setInspSpecHasUprSpecLimitChange( @Nullable final String inspSpecHasUprSpecLimitChange )
    {
        rememberChangedField("InspSpecHasUprSpecLimitChange", this.inspSpecHasUprSpecLimitChange);
        this.inspSpecHasUprSpecLimitChange = inspSpecHasUprSpecLimitChange;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecToleranceChgValidFrom</b>
     * </p>
     *
     * @param inspSpecToleranceChgValidFrom
     *            Date from Which the Tolerance Change Is Valid
     */
    public void setInspSpecToleranceChgValidFrom( @Nullable final LocalDateTime inspSpecToleranceChgValidFrom )
    {
        rememberChangedField("InspSpecToleranceChgValidFrom", this.inspSpecToleranceChgValidFrom);
        this.inspSpecToleranceChgValidFrom = inspSpecToleranceChgValidFrom;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecToleranceChgValidTo</b>
     * </p>
     *
     * @param inspSpecToleranceChgValidTo
     *            Date Until Which the Tolerance Change Is Valid
     */
    public void setInspSpecToleranceChgValidTo( @Nullable final LocalDateTime inspSpecToleranceChgValidTo )
    {
        rememberChangedField("InspSpecToleranceChgValidTo", this.inspSpecToleranceChgValidTo);
        this.inspSpecToleranceChgValidTo = inspSpecToleranceChgValidTo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeGrpRejection</b>
     * </p>
     *
     * @param inspSpecDefectCodeGrpRejection
     *            Defect Code Group for General Rejection
     */
    public void setInspSpecDefectCodeGrpRejection( @Nullable final String inspSpecDefectCodeGrpRejection )
    {
        rememberChangedField("InspSpecDefectCodeGrpRejection", this.inspSpecDefectCodeGrpRejection);
        this.inspSpecDefectCodeGrpRejection = inspSpecDefectCodeGrpRejection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeRejection</b>
     * </p>
     *
     * @param inspSpecDefectCodeRejection
     *            Defect Code for Rejection: General
     */
    public void setInspSpecDefectCodeRejection( @Nullable final String inspSpecDefectCodeRejection )
    {
        rememberChangedField("InspSpecDefectCodeRejection", this.inspSpecDefectCodeRejection);
        this.inspSpecDefectCodeRejection = inspSpecDefectCodeRejection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeGrpRjcnUpper</b>
     * </p>
     *
     * @param inspSpecDefectCodeGrpRjcnUpper
     *            Defect Code Group for Rejection at Upper Tolerance
     */
    public void setInspSpecDefectCodeGrpRjcnUpper( @Nullable final String inspSpecDefectCodeGrpRjcnUpper )
    {
        rememberChangedField("InspSpecDefectCodeGrpRjcnUpper", this.inspSpecDefectCodeGrpRjcnUpper);
        this.inspSpecDefectCodeGrpRjcnUpper = inspSpecDefectCodeGrpRjcnUpper;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeRjcnUpper</b>
     * </p>
     *
     * @param inspSpecDefectCodeRjcnUpper
     *            Defect Code for Rejection at Upper Specification Limit
     */
    public void setInspSpecDefectCodeRjcnUpper( @Nullable final String inspSpecDefectCodeRjcnUpper )
    {
        rememberChangedField("InspSpecDefectCodeRjcnUpper", this.inspSpecDefectCodeRjcnUpper);
        this.inspSpecDefectCodeRjcnUpper = inspSpecDefectCodeRjcnUpper;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeGrpRjcnLower</b>
     * </p>
     *
     * @param inspSpecDefectCodeGrpRjcnLower
     *            Defect Code Group for Rejection at Lower Tolerance
     */
    public void setInspSpecDefectCodeGrpRjcnLower( @Nullable final String inspSpecDefectCodeGrpRjcnLower )
    {
        rememberChangedField("InspSpecDefectCodeGrpRjcnLower", this.inspSpecDefectCodeGrpRjcnLower);
        this.inspSpecDefectCodeGrpRjcnLower = inspSpecDefectCodeGrpRjcnLower;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InspSpecDefectCodeRjcnLower</b>
     * </p>
     *
     * @param inspSpecDefectCodeRjcnLower
     *            Defect Code for Rejection at Lower Specification Limit
     */
    public void setInspSpecDefectCodeRjcnLower( @Nullable final String inspSpecDefectCodeRjcnLower )
    {
        rememberChangedField("InspSpecDefectCodeRjcnLower", this.inspSpecDefectCodeRjcnLower);
        this.inspSpecDefectCodeRjcnLower = inspSpecDefectCodeRjcnLower;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicInternalID</b>
     * </p>
     *
     * @param characteristicInternalID
     *            Internal characteristic
     */
    public void setCharacteristicInternalID( @Nullable final String characteristicInternalID )
    {
        rememberChangedField("CharacteristicInternalID", this.characteristicInternalID);
        this.characteristicInternalID = characteristicInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DefectFractionEstimationProced</b>
     * </p>
     *
     * @param defectFractionEstimationProced
     *            Fraction Calculation
     */
    public void setDefectFractionEstimationProced( @Nullable final String defectFractionEstimationProced )
    {
        rememberChangedField("DefectFractionEstimationProced", this.defectFractionEstimationProced);
        this.defectFractionEstimationProced = defectFractionEstimationProced;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_InspectionSpecification";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InspectionSpecification", getInspectionSpecification());
        result.put("InspectionSpecificationVersion", getInspectionSpecificationVersion());
        result.put("InspectionSpecificationPlant", getInspectionSpecificationPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InspectionSpecification", getInspectionSpecification());
        values.put("InspectionSpecificationVersion", getInspectionSpecificationVersion());
        values.put("InspectionSpecificationPlant", getInspectionSpecificationPlant());
        values.put("Plant", getPlant());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("InspectionSpecificationSrchTxt", getInspectionSpecificationSrchTxt());
        values.put("InspSpecGlobalName", getInspSpecGlobalName());
        values.put("InspectionSpecificationStatus", getInspectionSpecificationStatus());
        values.put("InspSpecTransferType", getInspSpecTransferType());
        values.put("InspSpecCreatedByUser", getInspSpecCreatedByUser());
        values.put("InspSpecCreationDate", getInspSpecCreationDate());
        values.put("InspSpecChangedByUser", getInspSpecChangedByUser());
        values.put("InspSpecChangeDate", getInspSpecChangeDate());
        values.put("InspSpecIsQuantitative", getInspSpecIsQuantitative());
        values.put("InspSpecCharacteristicType", getInspSpecCharacteristicType());
        values.put("InspSpecIsMeasuredValueRqd", getInspSpecIsMeasuredValueRqd());
        values.put("InspSpecIsSelectedSetRequired", getInspSpecIsSelectedSetRequired());
        values.put("InspSpecIsUpperLimitRequired", getInspSpecIsUpperLimitRequired());
        values.put("InspSpecIsLowerLimitRequired", getInspSpecIsLowerLimitRequired());
        values.put("InspSpecIsTargetValueInLimit", getInspSpecIsTargetValueInLimit());
        values.put("InspectionScope", getInspectionScope());
        values.put("InspSpecIsLongTermInspection", getInspSpecIsLongTermInspection());
        values.put("InspSpecRecordingType", getInspSpecRecordingType());
        values.put("InspResultIsDocumentationRqd", getInspResultIsDocumentationRqd());
        values.put("InspSpecCharcCategory", getInspSpecCharcCategory());
        values.put("InspSpecIsDefectsRecgAutomatic", getInspSpecIsDefectsRecgAutomatic());
        values.put("InspSpecIsSampleQtyAdditive", getInspSpecIsSampleQtyAdditive());
        values.put("InspSpecIsDestructive", getInspSpecIsDestructive());
        values.put("InspSpecResultCalculation", getInspSpecResultCalculation());
        values.put("InspSpecIsSamplingProcedRqd", getInspSpecIsSamplingProcedRqd());
        values.put("InspSpecIsScrapRelevant", getInspSpecIsScrapRelevant());
        values.put("InspSpecIsTestEquipmentRqd", getInspSpecIsTestEquipmentRqd());
        values.put("InspSpecIsChgDocRequired", getInspSpecIsChgDocRequired());
        values.put("InspSpecIsControlChartUsed", getInspSpecIsControlChartUsed());
        values.put("InspSpecPrintControl", getInspSpecPrintControl());
        values.put("InspSpecImportanceCode", getInspSpecImportanceCode());
        values.put("InspectorQualification", getInspectorQualification());
        values.put("InspSpecInformationField1", getInspSpecInformationField1());
        values.put("InspSpecInformationField2", getInspSpecInformationField2());
        values.put("InspSpecInformationField3", getInspSpecInformationField3());
        values.put("QltyMstrDataAuthorizationGroup", getQltyMstrDataAuthorizationGroup());
        values.put("InspToleranceSpecification", getInspToleranceSpecification());
        values.put("InspSpecDecimalPlaces", getInspSpecDecimalPlaces());
        values.put("InspectionSpecificationUnit", getInspectionSpecificationUnit());
        values.put("InspSpecificationUnitTechName", getInspSpecificationUnitTechName());
        values.put("InspSpecificationUnitISOCode", getInspSpecificationUnitISOCode());
        values.put("InspSpecificationUnitSAPCode", getInspSpecificationUnitSAPCode());
        values.put("InspSpecTargetValue", getInspSpecTargetValue());
        values.put("InspSpecHasTargetValue", getInspSpecHasTargetValue());
        values.put("InspSpecLowerLimit", getInspSpecLowerLimit());
        values.put("InspSpecHasLowerLimit", getInspSpecHasLowerLimit());
        values.put("InspSpecLowerPlausibilityLimit", getInspSpecLowerPlausibilityLimit());
        values.put("InspSpecHasLowrPlausibilityLmt", getInspSpecHasLowrPlausibilityLmt());
        values.put("InspSpecFirstLowerSpecLimit", getInspSpecFirstLowerSpecLimit());
        values.put("InspSpecHasFirstLowerSpecLimit", getInspSpecHasFirstLowerSpecLimit());
        values.put("InspSpecSecondLowerSpecLimit", getInspSpecSecondLowerSpecLimit());
        values.put("InspSpecHasSecondLowrSpecLimit", getInspSpecHasSecondLowrSpecLimit());
        values.put("InspSpecLowerSpecLimitChange", getInspSpecLowerSpecLimitChange());
        values.put("InspSpecHasLowrSpecLimitChange", getInspSpecHasLowrSpecLimitChange());
        values.put("InspSpecUpperLimit", getInspSpecUpperLimit());
        values.put("InspSpecHasUpperLimit", getInspSpecHasUpperLimit());
        values.put("InspSpecUpperPlausibilityLimit", getInspSpecUpperPlausibilityLimit());
        values.put("InspSpecHasUprPlausibilityLmt", getInspSpecHasUprPlausibilityLmt());
        values.put("InspSpecFirstUpperSpecLimit", getInspSpecFirstUpperSpecLimit());
        values.put("InspSpecHasFirstUpperSpecLimit", getInspSpecHasFirstUpperSpecLimit());
        values.put("InspSpecSecondUpperSpecLimit", getInspSpecSecondUpperSpecLimit());
        values.put("InspSpecHasSecondUprSpecLimit", getInspSpecHasSecondUprSpecLimit());
        values.put("InspSpecUpperSpecLimitChange", getInspSpecUpperSpecLimitChange());
        values.put("InspSpecHasUprSpecLimitChange", getInspSpecHasUprSpecLimitChange());
        values.put("InspSpecToleranceChgValidFrom", getInspSpecToleranceChgValidFrom());
        values.put("InspSpecToleranceChgValidTo", getInspSpecToleranceChgValidTo());
        values.put("InspSpecDefectCodeGrpRejection", getInspSpecDefectCodeGrpRejection());
        values.put("InspSpecDefectCodeRejection", getInspSpecDefectCodeRejection());
        values.put("InspSpecDefectCodeGrpRjcnUpper", getInspSpecDefectCodeGrpRjcnUpper());
        values.put("InspSpecDefectCodeRjcnUpper", getInspSpecDefectCodeRjcnUpper());
        values.put("InspSpecDefectCodeGrpRjcnLower", getInspSpecDefectCodeGrpRjcnLower());
        values.put("InspSpecDefectCodeRjcnLower", getInspSpecDefectCodeRjcnLower());
        values.put("CharacteristicInternalID", getCharacteristicInternalID());
        values.put("DefectFractionEstimationProced", getDefectFractionEstimationProced());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InspectionSpecification") ) {
                final Object value = values.remove("InspectionSpecification");
                if( (value == null) || (!value.equals(getInspectionSpecification())) ) {
                    setInspectionSpecification(((String) value));
                }
            }
            if( values.containsKey("InspectionSpecificationVersion") ) {
                final Object value = values.remove("InspectionSpecificationVersion");
                if( (value == null) || (!value.equals(getInspectionSpecificationVersion())) ) {
                    setInspectionSpecificationVersion(((String) value));
                }
            }
            if( values.containsKey("InspectionSpecificationPlant") ) {
                final Object value = values.remove("InspectionSpecificationPlant");
                if( (value == null) || (!value.equals(getInspectionSpecificationPlant())) ) {
                    setInspectionSpecificationPlant(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspectionSpecificationSrchTxt") ) {
                final Object value = values.remove("InspectionSpecificationSrchTxt");
                if( (value == null) || (!value.equals(getInspectionSpecificationSrchTxt())) ) {
                    setInspectionSpecificationSrchTxt(((String) value));
                }
            }
            if( values.containsKey("InspSpecGlobalName") ) {
                final Object value = values.remove("InspSpecGlobalName");
                if( (value == null) || (!value.equals(getInspSpecGlobalName())) ) {
                    setInspSpecGlobalName(((String) value));
                }
            }
            if( values.containsKey("InspectionSpecificationStatus") ) {
                final Object value = values.remove("InspectionSpecificationStatus");
                if( (value == null) || (!value.equals(getInspectionSpecificationStatus())) ) {
                    setInspectionSpecificationStatus(((String) value));
                }
            }
            if( values.containsKey("InspSpecTransferType") ) {
                final Object value = values.remove("InspSpecTransferType");
                if( (value == null) || (!value.equals(getInspSpecTransferType())) ) {
                    setInspSpecTransferType(((String) value));
                }
            }
            if( values.containsKey("InspSpecCreatedByUser") ) {
                final Object value = values.remove("InspSpecCreatedByUser");
                if( (value == null) || (!value.equals(getInspSpecCreatedByUser())) ) {
                    setInspSpecCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("InspSpecCreationDate") ) {
                final Object value = values.remove("InspSpecCreationDate");
                if( (value == null) || (!value.equals(getInspSpecCreationDate())) ) {
                    setInspSpecCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspSpecChangedByUser") ) {
                final Object value = values.remove("InspSpecChangedByUser");
                if( (value == null) || (!value.equals(getInspSpecChangedByUser())) ) {
                    setInspSpecChangedByUser(((String) value));
                }
            }
            if( values.containsKey("InspSpecChangeDate") ) {
                final Object value = values.remove("InspSpecChangeDate");
                if( (value == null) || (!value.equals(getInspSpecChangeDate())) ) {
                    setInspSpecChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspSpecIsQuantitative") ) {
                final Object value = values.remove("InspSpecIsQuantitative");
                if( (value == null) || (!value.equals(getInspSpecIsQuantitative())) ) {
                    setInspSpecIsQuantitative(((Boolean) value));
                }
            }
            if( values.containsKey("InspSpecCharacteristicType") ) {
                final Object value = values.remove("InspSpecCharacteristicType");
                if( (value == null) || (!value.equals(getInspSpecCharacteristicType())) ) {
                    setInspSpecCharacteristicType(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsMeasuredValueRqd") ) {
                final Object value = values.remove("InspSpecIsMeasuredValueRqd");
                if( (value == null) || (!value.equals(getInspSpecIsMeasuredValueRqd())) ) {
                    setInspSpecIsMeasuredValueRqd(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsSelectedSetRequired") ) {
                final Object value = values.remove("InspSpecIsSelectedSetRequired");
                if( (value == null) || (!value.equals(getInspSpecIsSelectedSetRequired())) ) {
                    setInspSpecIsSelectedSetRequired(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsUpperLimitRequired") ) {
                final Object value = values.remove("InspSpecIsUpperLimitRequired");
                if( (value == null) || (!value.equals(getInspSpecIsUpperLimitRequired())) ) {
                    setInspSpecIsUpperLimitRequired(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsLowerLimitRequired") ) {
                final Object value = values.remove("InspSpecIsLowerLimitRequired");
                if( (value == null) || (!value.equals(getInspSpecIsLowerLimitRequired())) ) {
                    setInspSpecIsLowerLimitRequired(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsTargetValueInLimit") ) {
                final Object value = values.remove("InspSpecIsTargetValueInLimit");
                if( (value == null) || (!value.equals(getInspSpecIsTargetValueInLimit())) ) {
                    setInspSpecIsTargetValueInLimit(((String) value));
                }
            }
            if( values.containsKey("InspectionScope") ) {
                final Object value = values.remove("InspectionScope");
                if( (value == null) || (!value.equals(getInspectionScope())) ) {
                    setInspectionScope(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsLongTermInspection") ) {
                final Object value = values.remove("InspSpecIsLongTermInspection");
                if( (value == null) || (!value.equals(getInspSpecIsLongTermInspection())) ) {
                    setInspSpecIsLongTermInspection(((String) value));
                }
            }
            if( values.containsKey("InspSpecRecordingType") ) {
                final Object value = values.remove("InspSpecRecordingType");
                if( (value == null) || (!value.equals(getInspSpecRecordingType())) ) {
                    setInspSpecRecordingType(((String) value));
                }
            }
            if( values.containsKey("InspResultIsDocumentationRqd") ) {
                final Object value = values.remove("InspResultIsDocumentationRqd");
                if( (value == null) || (!value.equals(getInspResultIsDocumentationRqd())) ) {
                    setInspResultIsDocumentationRqd(((String) value));
                }
            }
            if( values.containsKey("InspSpecCharcCategory") ) {
                final Object value = values.remove("InspSpecCharcCategory");
                if( (value == null) || (!value.equals(getInspSpecCharcCategory())) ) {
                    setInspSpecCharcCategory(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsDefectsRecgAutomatic") ) {
                final Object value = values.remove("InspSpecIsDefectsRecgAutomatic");
                if( (value == null) || (!value.equals(getInspSpecIsDefectsRecgAutomatic())) ) {
                    setInspSpecIsDefectsRecgAutomatic(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsSampleQtyAdditive") ) {
                final Object value = values.remove("InspSpecIsSampleQtyAdditive");
                if( (value == null) || (!value.equals(getInspSpecIsSampleQtyAdditive())) ) {
                    setInspSpecIsSampleQtyAdditive(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsDestructive") ) {
                final Object value = values.remove("InspSpecIsDestructive");
                if( (value == null) || (!value.equals(getInspSpecIsDestructive())) ) {
                    setInspSpecIsDestructive(((String) value));
                }
            }
            if( values.containsKey("InspSpecResultCalculation") ) {
                final Object value = values.remove("InspSpecResultCalculation");
                if( (value == null) || (!value.equals(getInspSpecResultCalculation())) ) {
                    setInspSpecResultCalculation(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsSamplingProcedRqd") ) {
                final Object value = values.remove("InspSpecIsSamplingProcedRqd");
                if( (value == null) || (!value.equals(getInspSpecIsSamplingProcedRqd())) ) {
                    setInspSpecIsSamplingProcedRqd(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsScrapRelevant") ) {
                final Object value = values.remove("InspSpecIsScrapRelevant");
                if( (value == null) || (!value.equals(getInspSpecIsScrapRelevant())) ) {
                    setInspSpecIsScrapRelevant(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsTestEquipmentRqd") ) {
                final Object value = values.remove("InspSpecIsTestEquipmentRqd");
                if( (value == null) || (!value.equals(getInspSpecIsTestEquipmentRqd())) ) {
                    setInspSpecIsTestEquipmentRqd(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsChgDocRequired") ) {
                final Object value = values.remove("InspSpecIsChgDocRequired");
                if( (value == null) || (!value.equals(getInspSpecIsChgDocRequired())) ) {
                    setInspSpecIsChgDocRequired(((String) value));
                }
            }
            if( values.containsKey("InspSpecIsControlChartUsed") ) {
                final Object value = values.remove("InspSpecIsControlChartUsed");
                if( (value == null) || (!value.equals(getInspSpecIsControlChartUsed())) ) {
                    setInspSpecIsControlChartUsed(((String) value));
                }
            }
            if( values.containsKey("InspSpecPrintControl") ) {
                final Object value = values.remove("InspSpecPrintControl");
                if( (value == null) || (!value.equals(getInspSpecPrintControl())) ) {
                    setInspSpecPrintControl(((String) value));
                }
            }
            if( values.containsKey("InspSpecImportanceCode") ) {
                final Object value = values.remove("InspSpecImportanceCode");
                if( (value == null) || (!value.equals(getInspSpecImportanceCode())) ) {
                    setInspSpecImportanceCode(((String) value));
                }
            }
            if( values.containsKey("InspectorQualification") ) {
                final Object value = values.remove("InspectorQualification");
                if( (value == null) || (!value.equals(getInspectorQualification())) ) {
                    setInspectorQualification(((String) value));
                }
            }
            if( values.containsKey("InspSpecInformationField1") ) {
                final Object value = values.remove("InspSpecInformationField1");
                if( (value == null) || (!value.equals(getInspSpecInformationField1())) ) {
                    setInspSpecInformationField1(((String) value));
                }
            }
            if( values.containsKey("InspSpecInformationField2") ) {
                final Object value = values.remove("InspSpecInformationField2");
                if( (value == null) || (!value.equals(getInspSpecInformationField2())) ) {
                    setInspSpecInformationField2(((String) value));
                }
            }
            if( values.containsKey("InspSpecInformationField3") ) {
                final Object value = values.remove("InspSpecInformationField3");
                if( (value == null) || (!value.equals(getInspSpecInformationField3())) ) {
                    setInspSpecInformationField3(((String) value));
                }
            }
            if( values.containsKey("QltyMstrDataAuthorizationGroup") ) {
                final Object value = values.remove("QltyMstrDataAuthorizationGroup");
                if( (value == null) || (!value.equals(getQltyMstrDataAuthorizationGroup())) ) {
                    setQltyMstrDataAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("InspToleranceSpecification") ) {
                final Object value = values.remove("InspToleranceSpecification");
                if( (value == null) || (!value.equals(getInspToleranceSpecification())) ) {
                    setInspToleranceSpecification(((String) value));
                }
            }
            if( values.containsKey("InspSpecDecimalPlaces") ) {
                final Object value = values.remove("InspSpecDecimalPlaces");
                if( (value == null) || (!value.equals(getInspSpecDecimalPlaces())) ) {
                    setInspSpecDecimalPlaces(((Short) value));
                }
            }
            if( values.containsKey("InspectionSpecificationUnit") ) {
                final Object value = values.remove("InspectionSpecificationUnit");
                if( (value == null) || (!value.equals(getInspectionSpecificationUnit())) ) {
                    setInspectionSpecificationUnit(((String) value));
                }
            }
            if( values.containsKey("InspSpecificationUnitTechName") ) {
                final Object value = values.remove("InspSpecificationUnitTechName");
                if( (value == null) || (!value.equals(getInspSpecificationUnitTechName())) ) {
                    setInspSpecificationUnitTechName(((String) value));
                }
            }
            if( values.containsKey("InspSpecificationUnitISOCode") ) {
                final Object value = values.remove("InspSpecificationUnitISOCode");
                if( (value == null) || (!value.equals(getInspSpecificationUnitISOCode())) ) {
                    setInspSpecificationUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("InspSpecificationUnitSAPCode") ) {
                final Object value = values.remove("InspSpecificationUnitSAPCode");
                if( (value == null) || (!value.equals(getInspSpecificationUnitSAPCode())) ) {
                    setInspSpecificationUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("InspSpecTargetValue") ) {
                final Object value = values.remove("InspSpecTargetValue");
                if( (value == null) || (!value.equals(getInspSpecTargetValue())) ) {
                    setInspSpecTargetValue(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasTargetValue") ) {
                final Object value = values.remove("InspSpecHasTargetValue");
                if( (value == null) || (!value.equals(getInspSpecHasTargetValue())) ) {
                    setInspSpecHasTargetValue(((String) value));
                }
            }
            if( values.containsKey("InspSpecLowerLimit") ) {
                final Object value = values.remove("InspSpecLowerLimit");
                if( (value == null) || (!value.equals(getInspSpecLowerLimit())) ) {
                    setInspSpecLowerLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasLowerLimit") ) {
                final Object value = values.remove("InspSpecHasLowerLimit");
                if( (value == null) || (!value.equals(getInspSpecHasLowerLimit())) ) {
                    setInspSpecHasLowerLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecLowerPlausibilityLimit") ) {
                final Object value = values.remove("InspSpecLowerPlausibilityLimit");
                if( (value == null) || (!value.equals(getInspSpecLowerPlausibilityLimit())) ) {
                    setInspSpecLowerPlausibilityLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasLowrPlausibilityLmt") ) {
                final Object value = values.remove("InspSpecHasLowrPlausibilityLmt");
                if( (value == null) || (!value.equals(getInspSpecHasLowrPlausibilityLmt())) ) {
                    setInspSpecHasLowrPlausibilityLmt(((String) value));
                }
            }
            if( values.containsKey("InspSpecFirstLowerSpecLimit") ) {
                final Object value = values.remove("InspSpecFirstLowerSpecLimit");
                if( (value == null) || (!value.equals(getInspSpecFirstLowerSpecLimit())) ) {
                    setInspSpecFirstLowerSpecLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasFirstLowerSpecLimit") ) {
                final Object value = values.remove("InspSpecHasFirstLowerSpecLimit");
                if( (value == null) || (!value.equals(getInspSpecHasFirstLowerSpecLimit())) ) {
                    setInspSpecHasFirstLowerSpecLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecSecondLowerSpecLimit") ) {
                final Object value = values.remove("InspSpecSecondLowerSpecLimit");
                if( (value == null) || (!value.equals(getInspSpecSecondLowerSpecLimit())) ) {
                    setInspSpecSecondLowerSpecLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasSecondLowrSpecLimit") ) {
                final Object value = values.remove("InspSpecHasSecondLowrSpecLimit");
                if( (value == null) || (!value.equals(getInspSpecHasSecondLowrSpecLimit())) ) {
                    setInspSpecHasSecondLowrSpecLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecLowerSpecLimitChange") ) {
                final Object value = values.remove("InspSpecLowerSpecLimitChange");
                if( (value == null) || (!value.equals(getInspSpecLowerSpecLimitChange())) ) {
                    setInspSpecLowerSpecLimitChange(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasLowrSpecLimitChange") ) {
                final Object value = values.remove("InspSpecHasLowrSpecLimitChange");
                if( (value == null) || (!value.equals(getInspSpecHasLowrSpecLimitChange())) ) {
                    setInspSpecHasLowrSpecLimitChange(((String) value));
                }
            }
            if( values.containsKey("InspSpecUpperLimit") ) {
                final Object value = values.remove("InspSpecUpperLimit");
                if( (value == null) || (!value.equals(getInspSpecUpperLimit())) ) {
                    setInspSpecUpperLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasUpperLimit") ) {
                final Object value = values.remove("InspSpecHasUpperLimit");
                if( (value == null) || (!value.equals(getInspSpecHasUpperLimit())) ) {
                    setInspSpecHasUpperLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecUpperPlausibilityLimit") ) {
                final Object value = values.remove("InspSpecUpperPlausibilityLimit");
                if( (value == null) || (!value.equals(getInspSpecUpperPlausibilityLimit())) ) {
                    setInspSpecUpperPlausibilityLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasUprPlausibilityLmt") ) {
                final Object value = values.remove("InspSpecHasUprPlausibilityLmt");
                if( (value == null) || (!value.equals(getInspSpecHasUprPlausibilityLmt())) ) {
                    setInspSpecHasUprPlausibilityLmt(((String) value));
                }
            }
            if( values.containsKey("InspSpecFirstUpperSpecLimit") ) {
                final Object value = values.remove("InspSpecFirstUpperSpecLimit");
                if( (value == null) || (!value.equals(getInspSpecFirstUpperSpecLimit())) ) {
                    setInspSpecFirstUpperSpecLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasFirstUpperSpecLimit") ) {
                final Object value = values.remove("InspSpecHasFirstUpperSpecLimit");
                if( (value == null) || (!value.equals(getInspSpecHasFirstUpperSpecLimit())) ) {
                    setInspSpecHasFirstUpperSpecLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecSecondUpperSpecLimit") ) {
                final Object value = values.remove("InspSpecSecondUpperSpecLimit");
                if( (value == null) || (!value.equals(getInspSpecSecondUpperSpecLimit())) ) {
                    setInspSpecSecondUpperSpecLimit(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasSecondUprSpecLimit") ) {
                final Object value = values.remove("InspSpecHasSecondUprSpecLimit");
                if( (value == null) || (!value.equals(getInspSpecHasSecondUprSpecLimit())) ) {
                    setInspSpecHasSecondUprSpecLimit(((String) value));
                }
            }
            if( values.containsKey("InspSpecUpperSpecLimitChange") ) {
                final Object value = values.remove("InspSpecUpperSpecLimitChange");
                if( (value == null) || (!value.equals(getInspSpecUpperSpecLimitChange())) ) {
                    setInspSpecUpperSpecLimitChange(((Double) value));
                }
            }
            if( values.containsKey("InspSpecHasUprSpecLimitChange") ) {
                final Object value = values.remove("InspSpecHasUprSpecLimitChange");
                if( (value == null) || (!value.equals(getInspSpecHasUprSpecLimitChange())) ) {
                    setInspSpecHasUprSpecLimitChange(((String) value));
                }
            }
            if( values.containsKey("InspSpecToleranceChgValidFrom") ) {
                final Object value = values.remove("InspSpecToleranceChgValidFrom");
                if( (value == null) || (!value.equals(getInspSpecToleranceChgValidFrom())) ) {
                    setInspSpecToleranceChgValidFrom(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspSpecToleranceChgValidTo") ) {
                final Object value = values.remove("InspSpecToleranceChgValidTo");
                if( (value == null) || (!value.equals(getInspSpecToleranceChgValidTo())) ) {
                    setInspSpecToleranceChgValidTo(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InspSpecDefectCodeGrpRejection") ) {
                final Object value = values.remove("InspSpecDefectCodeGrpRejection");
                if( (value == null) || (!value.equals(getInspSpecDefectCodeGrpRejection())) ) {
                    setInspSpecDefectCodeGrpRejection(((String) value));
                }
            }
            if( values.containsKey("InspSpecDefectCodeRejection") ) {
                final Object value = values.remove("InspSpecDefectCodeRejection");
                if( (value == null) || (!value.equals(getInspSpecDefectCodeRejection())) ) {
                    setInspSpecDefectCodeRejection(((String) value));
                }
            }
            if( values.containsKey("InspSpecDefectCodeGrpRjcnUpper") ) {
                final Object value = values.remove("InspSpecDefectCodeGrpRjcnUpper");
                if( (value == null) || (!value.equals(getInspSpecDefectCodeGrpRjcnUpper())) ) {
                    setInspSpecDefectCodeGrpRjcnUpper(((String) value));
                }
            }
            if( values.containsKey("InspSpecDefectCodeRjcnUpper") ) {
                final Object value = values.remove("InspSpecDefectCodeRjcnUpper");
                if( (value == null) || (!value.equals(getInspSpecDefectCodeRjcnUpper())) ) {
                    setInspSpecDefectCodeRjcnUpper(((String) value));
                }
            }
            if( values.containsKey("InspSpecDefectCodeGrpRjcnLower") ) {
                final Object value = values.remove("InspSpecDefectCodeGrpRjcnLower");
                if( (value == null) || (!value.equals(getInspSpecDefectCodeGrpRjcnLower())) ) {
                    setInspSpecDefectCodeGrpRjcnLower(((String) value));
                }
            }
            if( values.containsKey("InspSpecDefectCodeRjcnLower") ) {
                final Object value = values.remove("InspSpecDefectCodeRjcnLower");
                if( (value == null) || (!value.equals(getInspSpecDefectCodeRjcnLower())) ) {
                    setInspSpecDefectCodeRjcnLower(((String) value));
                }
            }
            if( values.containsKey("CharacteristicInternalID") ) {
                final Object value = values.remove("CharacteristicInternalID");
                if( (value == null) || (!value.equals(getCharacteristicInternalID())) ) {
                    setCharacteristicInternalID(((String) value));
                }
            }
            if( values.containsKey("DefectFractionEstimationProced") ) {
                final Object value = values.remove("DefectFractionEstimationProced");
                if( (value == null) || (!value.equals(getDefectFractionEstimationProced())) ) {
                    setDefectFractionEstimationProced(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        InspectionSpecificationText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new InspectionSpecificationText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> InspectionSpecificationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new InspectionSpecificationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> InspectionSpecificationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new InspectionSpecificationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterInspectionCharacteristicService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>InspectionSpecificationText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>InspectionSpecificationText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<InspectionSpecificationText> fetchText()
    {
        return fetchFieldAsList("to_Text", InspectionSpecificationText.class);
    }

    /**
     * Retrieval of associated <b>InspectionSpecificationText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>InspectionSpecification</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>InspectionSpecificationText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<InspectionSpecificationText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>InspectionSpecificationText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>InspectionSpecification</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>InspectionSpecificationText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<InspectionSpecificationText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>InspectionSpecificationText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>InspectionSpecification</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>InspectionSpecificationText</b> entities.
     */
    public void setText( @Nonnull final List<InspectionSpecificationText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>InspectionSpecificationText</b> entities. This corresponds to the
     * OData navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>InspectionSpecification</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>InspectionSpecificationText</b> entities.
     */
    public void addText( InspectionSpecificationText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of InspectionSpecification instances.
     *
     */
    public final static class InspectionSpecificationBuilder
    {

        private List<InspectionSpecificationText> toText = Lists.newArrayList();

        private InspectionSpecification.InspectionSpecificationBuilder toText(
            final List<InspectionSpecificationText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>InspectionSpecification</b> to multiple
         * <b>InspectionSpecificationText</b>.
         *
         * @param value
         *            The InspectionSpecificationTexts to build this InspectionSpecification with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InspectionSpecification.InspectionSpecificationBuilder text( InspectionSpecificationText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
